/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DelegateCloseHandler;
import net.sourceforge.javadpkg.io.impl.UncloseableInputStream;

public class DataFileSource
implements DataSource {
    private File file;
    private boolean resettable;
    private String name;
    private InputStream in;
    private UncloseableInputStream publicIn;
    private boolean opened;

    public DataFileSource(File file, boolean resettable) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        this.file = file;
        this.name = file.getAbsolutePath();
        this.in = null;
        this.publicIn = null;
        this.opened = false;
        this.resettable = resettable;
    }

    public DataFileSource(File file) {
        this(file, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isResettable() {
        return this.resettable;
    }

    @Override
    public void reset() throws IOException {
        if (!this.resettable) {
            throw new IOException("Source |" + this.name + "| doesn't support a reset.");
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            this.in = null;
            this.publicIn = null;
            this.opened = false;
        }
    }

    private void createPublicInputStream() {
        this.publicIn = new UncloseableInputStream(this.in, new DelegateCloseHandler(this));
    }

    private void ensureInputStream() throws IOException {
        if (this.in == null) {
            if (!this.opened) {
                try {
                    this.in = Streams.createBufferedFileInputStream(this.file);
                }
                catch (FileNotFoundException e) {
                    throw new IOException("Couldn't open stream on source |" + this.name + "|: " + e.getMessage());
                }
                this.createPublicInputStream();
            } else {
                throw new IOException("The stream of source |" + this.name + "| is already closed.");
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.ensureInputStream();
        return this.publicIn;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            this.publicIn = null;
            this.in = null;
        }
    }
}

