/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.security.MessageDigest;
import net.sourceforge.javadpkg.io.DataConsumer;

public class DataDigestConsumer
implements DataConsumer {
    private MessageDigest digest;
    private String name;

    public DataDigestConsumer(MessageDigest digest, String name) {
        if (digest == null) {
            throw new IllegalArgumentException("Argument digest is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.digest = digest;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void consume(byte[] buffer, int length) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer is null.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Argument length is negative: " + length);
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("Argument length is greater than the buffer length. Length: " + length + "; buffer length: " + buffer.length);
        }
        this.digest.update(buffer, 0, length);
    }
}

