/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataSwap;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;

public class DataByteArraySwap
implements DataSwap {
    private String name;
    private ByteArrayOutputStream out;
    private DataTarget target;
    private DataSource source;
    private boolean closed;

    public DataByteArraySwap(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.name = name;
    }

    @Override
    public DataTarget getTarget() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't return the target because the swap |" + this.name + "| was already closed.");
        }
        if (this.source != null) {
            throw new IllegalStateException("Can't return the target of the swap |" + this.name + "| because the corresponding source is already open.");
        }
        if (this.target != null) {
            return this.target;
        }
        this.out = new ByteArrayOutputStream();
        this.target = new DataStreamTarget(this.out, this.name, true);
        return this.target;
    }

    @Override
    public DataSource getSource() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't return the source because the swap |" + this.name + "| was already closed.");
        }
        if (this.source != null) {
            return this.source;
        }
        if (this.target == null) {
            throw new IllegalStateException("Can't return the source of the swap |" + this.name + "| because the corresponding target hasn't been opened yet.");
        }
        this.target.close();
        this.source = new DataStreamSource(new ByteArrayInputStream(this.out.toByteArray()), this.name, true);
        return this.source;
    }

    @Override
    public void close() throws IOException {
        block8: {
            try {
                if (this.target != null) {
                    try {
                        this.target.close();
                    }
                    catch (IOException e) {
                        throw new IOException("Couldn't close target of swap |" + this.name + "|: " + e.getMessage(), e);
                    }
                }
                if (this.source == null) break block8;
                try {
                    this.source.close();
                }
                catch (IOException e) {
                    throw new IOException("Couldn't close source of swap |" + this.name + "|: " + e.getMessage(), e);
                }
            }
            finally {
                this.out = null;
                this.target = null;
                this.source = null;
                this.closed = true;
            }
        }
    }
}

