/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.javadpkg.io.DataSource;

public class DataByteArraySource
implements DataSource {
    private byte[] data;
    private InputStream in;
    private String name;
    private boolean closeable;
    private boolean resettable;

    public DataByteArraySource(byte[] data, String name, boolean closeable, boolean resettable) {
        if (data == null) {
            throw new IllegalArgumentException("Argument data is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.data = (byte[])data.clone();
        this.in = new ByteArrayInputStream(this.data);
        this.name = name;
        this.closeable = closeable;
        this.resettable = resettable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLength() {
        return this.data.length;
    }

    @Override
    public boolean isResettable() {
        return this.resettable;
    }

    @Override
    public void reset() throws IOException {
        if (!this.resettable) {
            throw new IOException("Source |" + this.name + "| doesn't support a reset.");
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
        this.in = new ByteArrayInputStream(this.data);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in != null && this.closeable) {
                this.in.close();
            }
        }
        finally {
            if (this.closeable) {
                this.in = null;
            }
        }
    }
}

