/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sourceforge.javadpkg.io.DataConsumer;
import net.sourceforge.javadpkg.io.DataProducer;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamConsumer;
import net.sourceforge.javadpkg.io.impl.DataStreamProducer;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class Streams {
    private static final int DEFAULT_BLOCK_SIZE = 65536;
    private static final int DEFAULT_FILE_BUFFER_SIZE = 0x100000;

    private Streams() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        Streams.copy(in, out, 65536, -1L);
    }

    public static void copy(InputStream in, OutputStream out, int blockSize, long length) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Argument blockSize is less than 1: " + blockSize);
        }
        DataStreamProducer producer = new DataStreamProducer(in, "input stream");
        DataStreamConsumer consumer = new DataStreamConsumer(out, "output stream");
        Streams.transfer(producer, consumer, blockSize, length);
    }

    public static void transfer(DataProducer producer, DataConsumer consumer) throws IOException {
        if (producer == null) {
            throw new IllegalArgumentException("Argument producer is null.");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        Streams.transfer(producer, consumer, 65536, -1L);
    }

    public static void transfer(DataProducer producer, DataConsumer consumer, int blockSize, long length) throws IOException {
        if (producer == null) {
            throw new IllegalArgumentException("Argument producer is null.");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Argument blockSize is less than 1: " + blockSize);
        }
        boolean limited = length >= 0L;
        long remainingLength = length;
        if (!limited || remainingLength > 0L) {
            int readLength;
            byte[] buffer = new byte[blockSize];
            do {
                readLength = blockSize;
                if (limited && (long)readLength > remainingLength) {
                    readLength = (int)remainingLength;
                }
                try {
                    readLength = producer.produce(buffer);
                }
                catch (IOException e) {
                    throw new IOException("Couldn't read data from " + producer.getName() + " and pass to " + consumer.getName() + ": " + e.getMessage(), e);
                }
                if (readLength <= 0) continue;
                try {
                    consumer.consume(buffer, readLength);
                }
                catch (IOException e) {
                    throw new IOException("Couldn't read data from " + producer.getName() + " and pass to " + consumer.getName() + ": " + e.getMessage(), e);
                }
                if (!limited) continue;
                remainingLength -= (long)readLength;
            } while (readLength >= 0 && (!limited || remainingLength > 0L));
        }
    }

    public static void copy(DataSource source, DataTarget target) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        Streams.copy(source, target, 65536, -1L);
    }

    public static void copy(DataSource source, DataTarget target, int blockSize, long length) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Argument blockSize is less than 1: " + blockSize);
        }
        DataProducer producer = Streams.createProducer(source);
        DataConsumer consumer = Streams.createConsumer(target);
        Streams.transfer(producer, consumer, blockSize, length);
    }

    public static void compressGzip(DataSource source, DataTarget target, int compressionLevel) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (compressionLevel < -1 || compressionLevel > 9) {
            throw new IllegalArgumentException("Argument compressionLevel is out of bound. Lower limit: -1; upper limit: 9; compressionLevel: " + compressionLevel);
        }
        Streams.compressGzip(source, target, 65536, -1L, compressionLevel);
    }

    public static void compressGzip(DataSource source, DataTarget target, int blockSize, long length, int compressionLevel) throws IOException {
        DataStreamConsumer consumer;
        GzipCompressorOutputStream gzipOut;
        OutputStream out = null;
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (blockSize < 1) {
            throw new IllegalArgumentException("Argument blockSize is less than 1: " + blockSize);
        }
        if (compressionLevel < -1 || compressionLevel > 9) {
            throw new IllegalArgumentException("Argument compressionLevel is out of bound. Lower limit: -1; upper limit: 9; compressionLevel: " + compressionLevel);
        }
        DataProducer producer = Streams.createProducer(source);
        try {
            out = target.getOutputStream();
            GzipParameters gzipParameters = new GzipParameters();
            gzipParameters.setCompressionLevel(compressionLevel);
            gzipOut = new GzipCompressorOutputStream(out, gzipParameters);
            consumer = new DataStreamConsumer((OutputStream)gzipOut, target.getName());
        }
        catch (IOException e) {
            throw new IOException("Couldn't open GZIP stream on target |" + target.getName() + "|: " + e.getMessage(), e);
        }
        Streams.transfer(producer, consumer, blockSize, length);
        try {
            gzipOut.finish();
        }
        catch (IOException e) {
            throw new IOException("Couldn't finish GZIP stream on target |" + target.getName() + "|: " + e.getMessage(), e);
        }
    }

    public static DataProducer createProducer(DataSource source) throws IOException {
        InputStream in;
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        try {
            in = source.getInputStream();
        }
        catch (IOException e) {
            throw new IOException("Couldn't obtain input stream from source |" + source + "|: " + e.getMessage(), e);
        }
        DataStreamProducer producer = new DataStreamProducer(in, "source |" + source.getName() + "|");
        return producer;
    }

    public static DataConsumer createConsumer(DataTarget target) throws IOException {
        OutputStream out;
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        try {
            out = target.getOutputStream();
        }
        catch (IOException e) {
            throw new IOException("Couldn't obtain output stream from target |" + target + "|: " + e.getMessage(), e);
        }
        DataStreamConsumer consumer = new DataStreamConsumer(out, "target |" + target + "|");
        return consumer;
    }

    public static InputStream createBufferedFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        InputStream in = Streams.createBufferedFileInputStream(file, 0x100000);
        return in;
    }

    public static InputStream createBufferedFileInputStream(File file, int fileBufferSize) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        if (fileBufferSize < 1) {
            throw new IllegalArgumentException("Argument fileBufferSize is less than 1: " + fileBufferSize);
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), fileBufferSize);
        return in;
    }

    public static OutputStream createBufferedFileOutputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        OutputStream out = Streams.createBufferedFileOutputStream(file, 0x100000);
        return out;
    }

    public static OutputStream createBufferedFileOutputStream(File file, int fileBufferSize) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        if (fileBufferSize < 1) {
            throw new IllegalArgumentException("Argument fileBufferSize is less than 1: " + fileBufferSize);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), fileBufferSize);
        return out;
    }

    public static InputStream createResourceInputStream(Package pkg, ClassLoader loader, String name) throws FileNotFoundException {
        if (pkg == null) {
            throw new IllegalArgumentException("Argument pkg is null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Argument loader is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(pkg.getName().replace('.', '/'));
        sb.append('/');
        sb.append(name);
        String resourceName = sb.toString();
        InputStream in = loader.getResourceAsStream(resourceName);
        if (in == null) {
            File file = new File("src/" + resourceName);
            if (file.exists() && file.isFile()) {
                in = Streams.createBufferedFileInputStream(file);
            } else {
                throw new FileNotFoundException("Couldn't find resource |" + resourceName + "|.");
            }
        }
        return in;
    }

    public static InputStream createResourceInputStream(Class<?> clazz, String name) throws FileNotFoundException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        InputStream in = Streams.createResourceInputStream(clazz.getPackage(), clazz.getClassLoader(), name);
        return in;
    }

    public static DataSource createResourceDataSource(Package pkg, ClassLoader loader, String name) throws FileNotFoundException {
        if (pkg == null) {
            throw new IllegalArgumentException("Argument pkg is null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Argument loader is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        InputStream in = Streams.createResourceInputStream(pkg, loader, name);
        DataStreamSource source = new DataStreamSource(in, name, true);
        return source;
    }

    public static DataSource createResourceDataSource(Class<?> clazz, String name) throws FileNotFoundException {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument clazz is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        InputStream in = Streams.createResourceInputStream(clazz, name);
        DataStreamSource source = new DataStreamSource(in, name, true);
        return source;
    }
}

