/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Template;
import net.sourceforge.javadpkg.TemplateType;
import net.sourceforge.javadpkg.TemplateTypeParser;
import net.sourceforge.javadpkg.Templates;
import net.sourceforge.javadpkg.TemplatesConstants;
import net.sourceforge.javadpkg.TemplatesParser;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionParser;
import net.sourceforge.javadpkg.control.impl.DescriptionParserImpl;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldParser;
import net.sourceforge.javadpkg.field.impl.FieldParserImpl;
import net.sourceforge.javadpkg.impl.TemplateTypeParserImpl;
import net.sourceforge.javadpkg.impl.TemplatesDuplicatedTemplateWarning;
import net.sourceforge.javadpkg.impl.TemplatesMissingFieldWarning;
import net.sourceforge.javadpkg.impl.TemplatesUnsupportFieldNameWarning;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;

public class TemplatesParserImpl
implements TemplatesParser,
TemplatesConstants {
    private FieldParser fieldParser = new FieldParserImpl(true, true, false);
    private TemplateTypeParser templateTypeParser = new TemplateTypeParserImpl();
    private DescriptionParser descriptionParser = new DescriptionParserImpl();

    @Override
    public Templates parseTemplates(String value, Context context) throws ParseException {
        List<Field> fields;
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        try (DataStreamSource source = new DataStreamSource(new ByteArrayInputStream(value.getBytes("UTF-8")), "templates", false);){
            fields = this.parseFields(source, context);
        }
        catch (IOException | UnsupportedCharsetException e) {
            throw new ParseException("Couldn't parse fields of templates: " + e.getMessage(), e);
        }
        Templates templates = this.parseTemplates(fields, context);
        return templates;
    }

    @Override
    public Templates parseTemplates(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        List<Field> fields = this.parseFields(source, context);
        Templates templates = this.parseTemplates(fields, context);
        return templates;
    }

    private List<Field> parseFields(DataSource source, Context context) throws IOException, ParseException {
        List<Field> fields;
        try {
            fields = this.fieldParser.parseFieldsAsList(source, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't parse fields of templates: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse fields of templates: " + e.getMessage(), e);
        }
        return fields;
    }

    private Templates parseTemplates(List<Field> fields, Context context) throws ParseException {
        String name = null;
        TemplateType type = null;
        Map<String, String> defaultValues = null;
        Map<String, List<String>> choices = null;
        Map<String, Description> descriptions = null;
        TemplatesImpl templates = new TemplatesImpl();
        LinkedHashSet<String> unsupportedFieldNames = new LinkedHashSet<String>();
        try {
            for (Field field : fields) {
                if (field.isEmpty()) {
                    if (name != null) {
                        this.addTemplate(context, templates, name, type, defaultValues, choices, descriptions);
                    }
                    name = null;
                    type = null;
                    defaultValues = null;
                    choices = null;
                    descriptions = null;
                    continue;
                }
                if ("Template".equals(field.getName())) {
                    if (name != null) {
                        throw new ParseException("Found template |" + field.getValue() + "| without an empty line between it and the previous template |" + name + "|.");
                    }
                    type = null;
                    defaultValues = null;
                    choices = null;
                    descriptions = null;
                    name = field.getValue();
                    continue;
                }
                if (name == null) {
                    throw new ParseException("Found the field |" + field.getName() + "| without any corresponding template.");
                }
                if ("Type".equals(field.getName())) {
                    if (type != null) {
                        throw new ParseException("The field |" + field.getName() + "| exists more the one time in the template |" + name + "|.");
                    }
                    try {
                        type = this.templateTypeParser.parseTemplateType(field.getValue(), context);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ParseException("Couldn't parse field |" + field.getName() + "| in the template |" + name + "|: " + e.getMessage(), e);
                    }
                }
                if ("Default".equals(field.getName()) || field.getName().startsWith("Default-")) {
                    try {
                        defaultValues = this.parseDefaultValue(defaultValues, field);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ParseException("Couldn't parse field |" + field.getName() + "| in the template |" + name + "|: " + e.getMessage(), e);
                    }
                }
                if ("Choices".equals(field.getName()) || field.getName().startsWith("Choices-")) {
                    try {
                        choices = this.parseChoices(context, choices, field);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ParseException("Couldn't parse field |" + field.getName() + "| in the template |" + name + "|: " + e.getMessage(), e);
                    }
                }
                if ("Description".equals(field.getName()) || field.getName().startsWith("Description-")) {
                    try {
                        descriptions = this.parseDescription(context, descriptions, field);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ParseException("Couldn't parse field |" + field.getName() + "| in the template |" + name + "|: " + e.getMessage(), e);
                    }
                }
                if (unsupportedFieldNames.contains(field.getName())) continue;
                context.addWarning(new TemplatesUnsupportFieldNameWarning(field.getName()));
                unsupportedFieldNames.add(field.getName());
            }
            if (name != null) {
                this.addTemplate(context, templates, name, type, defaultValues, choices, descriptions);
            }
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse templates: " + e.getMessage(), e);
        }
        return templates;
    }

    private void addTemplate(Context context, TemplatesImpl templates, String name, TemplateType type, Map<String, String> defaultValues, Map<String, List<String>> choices, Map<String, Description> descriptions) throws ParseException {
        LinkedHashSet<String> missingFieldNames = new LinkedHashSet<String>();
        if (type == null) {
            missingFieldNames.add("Type");
        }
        if ((this.templateTypeParser.getTypeSelect().equals(type) || this.templateTypeParser.getTypeMultiselect().equals(type)) && choices == null) {
            missingFieldNames.add("Choices");
        }
        if (descriptions == null || !descriptions.containsKey("")) {
            context.addWarning(new TemplatesMissingFieldWarning(name, "Description"));
            descriptions = new HashMap<String, Description>();
        }
        if (!missingFieldNames.isEmpty()) {
            throw new ParseException("Missing fields " + this.getFieldNamesAsString(missingFieldNames) + " for template |" + name + "|.");
        }
        templates.addTemplate(name, type, defaultValues, choices, descriptions, context);
    }

    private Map<String, String> parseDefaultValue(Map<String, String> defaultValues, Field field) throws ParseException {
        Map<String, String> map = defaultValues == null ? new LinkedHashMap<String, String>() : defaultValues;
        String name = field.getName();
        if ("Default".equals(name)) {
            name = "";
        } else if (!(name = name.substring(8)).endsWith(".UTF-8")) {
            throw new ParseException("Found description |" + field.getName() + "|, but currently only UTF-8 is supported.");
        }
        if (map.containsKey(name)) {
            throw new ParseException("The field |" + field.getName() + "| exists more the one time in the template |" + name + "|.");
        }
        String text = field.getValue();
        map.put(name, text);
        return map;
    }

    private Map<String, List<String>> parseChoices(Context context, Map<String, List<String>> choices, Field field) throws ParseException {
        String[] parts;
        Map<String, List<String>> map = choices == null ? new LinkedHashMap<String, List<String>>() : choices;
        String name = field.getName();
        if ("Choices".equals(name)) {
            name = "";
        } else if (!(name = name.substring(8)).endsWith(".UTF-8")) {
            context.addWarning(new TemplatesUnsupportFieldNameWarning(field.getName()));
            return map;
        }
        if (map.containsKey(name)) {
            throw new ParseException("The field |" + field.getName() + "| exists more the one time in the template |" + name + "|.");
        }
        String value = field.getValue();
        ArrayList<String> values = new ArrayList<String>();
        for (String part : parts = value.split(",")) {
            String choice = part.trim();
            values.add(choice);
        }
        map.put(name, values);
        return map;
    }

    private Map<String, Description> parseDescription(Context context, Map<String, Description> descriptions, Field field) throws ParseException {
        Description description;
        Map<String, Description> map = descriptions == null ? new LinkedHashMap<String, Description>() : descriptions;
        String name = field.getName();
        if ("Description".equals(name)) {
            name = "";
        } else if (!(name = name.substring(12)).endsWith(".UTF-8")) {
            throw new ParseException("Found description |" + field.getName() + "|, but currently only UTF-8 is supported.");
        }
        if (map.containsKey(name)) {
            throw new ParseException("The field |" + field.getName() + "| exists more the one time in the template |" + name + "|.");
        }
        try {
            description = this.descriptionParser.parseDescription(field.getValue(), context);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
        }
        map.put(name, description);
        return map;
    }

    private String getFieldNamesAsString(Set<String> fieldNames) {
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNames) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append('|');
            sb.append(fieldName);
            sb.append('|');
        }
        return sb.toString();
    }

    private class TemplateImpl
    implements Template {
        private String name;
        private TemplateType type;
        private Map<String, String> defaultValues;
        private Map<String, List<String>> choices;
        private Map<String, Description> descriptions;

        public TemplateImpl(String name, TemplateType type, Map<String, String> defaultValues, Map<String, List<String>> choices, Map<String, Description> descriptions) {
            this.name = name;
            this.type = type;
            this.defaultValues = defaultValues == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(defaultValues);
            if (choices == null) {
                this.choices = null;
            } else {
                this.choices = new LinkedHashMap<String, List<String>>();
                for (Map.Entry<String, List<String>> entry : choices.entrySet()) {
                    this.choices.put(entry.getKey(), new ArrayList(entry.getValue()));
                }
            }
            this.descriptions = new LinkedHashMap<String, Description>(descriptions);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TemplateType getType() {
            return this.type;
        }

        @Override
        public Map<String, String> getDefaultValue() {
            return this.defaultValues;
        }

        @Override
        public Map<String, List<String>> getChoices() {
            return this.choices;
        }

        @Override
        public Map<String, Description> getDescriptions() {
            return this.descriptions;
        }
    }

    private class TemplatesImpl
    implements Templates {
        private Map<String, Template> templates = new LinkedHashMap<String, Template>();

        @Override
        public List<Template> getTemplates() {
            return new ArrayList<Template>(this.templates.values());
        }

        public void addTemplate(String name, TemplateType type, Map<String, String> defaultValues, Map<String, List<String>> choices, Map<String, Description> descriptions, Context context) {
            if (this.templates.containsKey(name)) {
                context.addWarning(new TemplatesDuplicatedTemplateWarning(name));
            } else {
                TemplateImpl template = new TemplateImpl(name, type, defaultValues, choices, descriptions);
                this.templates.put(name, template);
            }
        }
    }
}

