/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Template;
import net.sourceforge.javadpkg.TemplateTypeBuilder;
import net.sourceforge.javadpkg.Templates;
import net.sourceforge.javadpkg.TemplatesBuilder;
import net.sourceforge.javadpkg.TemplatesConstants;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionBuilder;
import net.sourceforge.javadpkg.control.impl.DescriptionBuilderImpl;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldBuilder;
import net.sourceforge.javadpkg.field.impl.FieldBuilderImpl;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.impl.TemplateTypeBuilderImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;

public class TemplatesBuilderImpl
implements TemplatesBuilder,
TemplatesConstants {
    private FieldBuilder fieldBuilder = new FieldBuilderImpl();
    private TemplateTypeBuilder templateTypeBuilder = new TemplateTypeBuilderImpl();
    private DescriptionBuilder descriptionBuilder = new DescriptionBuilderImpl();

    @Override
    public String buildTemplates(Templates templates, Context context) throws BuildException {
        String result;
        if (templates == null) {
            throw new IllegalArgumentException("Argument templates is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DataStreamTarget target = new DataStreamTarget(out, "templates", false);){
            this.buildTemplates(templates, target, context);
        }
        catch (IOException e) {
            throw new BuildException("Couldn't build templates: " + e.getMessage(), e);
        }
        try {
            result = new String(out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BuildException("Couldn't build templates: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public void buildTemplates(Templates templates, DataTarget target, Context context) throws IOException, BuildException {
        if (templates == null) {
            throw new IllegalArgumentException("Argument templates is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        List<Field> fields = this.buildFields(templates, context);
        this.writeFields(fields, target, context);
    }

    private List<Field> buildFields(Templates templates, Context context) throws BuildException {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Template template : templates.getTemplates()) {
            fields.add(new FieldImpl("Template", template.getName()));
            try {
                fields.add(new FieldImpl("Type", this.templateTypeBuilder.buildTemplateType(template.getType(), context)));
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build template |" + template.getName() + "|: Couldn't build field |" + "Type" + "|: " + e.getMessage(), e);
            }
            this.buildDefaultValues(fields, template.getDefaultValue());
            this.buildChoices(fields, template.getChoices());
            try {
                this.buildDescriptions(fields, template.getDescriptions(), context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build template |" + template.getName() + "|: " + e.getMessage(), e);
            }
        }
        return fields;
    }

    private void buildDefaultValues(List<Field> fields, Map<String, String> defaultValues) {
        String value = defaultValues.get("Default");
        if (value != null) {
            fields.add(new FieldImpl("Default", value));
        }
        for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
            if ("Default".equals(entry.getKey())) continue;
            fields.add(new FieldImpl("Default-" + entry.getKey(), entry.getValue()));
        }
    }

    private void buildChoices(List<Field> fields, Map<String, List<String>> choices) {
        List<String> values = choices.get("Choices");
        if (values != null) {
            fields.add(new FieldImpl("Choices", this.buildChoices(values)));
        }
        for (Map.Entry<String, List<String>> entry : choices.entrySet()) {
            if ("Choices".equals(entry.getKey())) continue;
            fields.add(new FieldImpl("Choices-" + entry.getKey(), this.buildChoices(entry.getValue())));
        }
    }

    private String buildChoices(List<String> choices) {
        StringBuilder sb = new StringBuilder();
        for (String choice : choices) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(choice);
        }
        return sb.toString();
    }

    private void buildDescriptions(List<Field> fields, Map<String, Description> descriptions, Context context) throws BuildException {
        String value;
        Description description = descriptions.get("Description");
        if (description != null) {
            try {
                value = this.descriptionBuilder.buildDescription(description, context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build description |Description|: " + e.getMessage(), e);
            }
            fields.add(new FieldImpl("Description", value));
        }
        for (Map.Entry<String, Description> entry : descriptions.entrySet()) {
            if ("Description".equals(entry.getKey())) continue;
            String name = "Description-" + entry.getKey();
            try {
                value = this.descriptionBuilder.buildDescription(entry.getValue(), context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build description |" + name + "|: " + e.getMessage(), e);
            }
            fields.add(new FieldImpl(name, value));
        }
    }

    private void writeFields(List<Field> fields, DataTarget target, Context context) throws IOException, BuildException {
        try {
            this.fieldBuilder.buildFields(fields, target, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't write fields of templates: " + e.getMessage(), e);
        }
        catch (BuildException e) {
            throw new BuildException("Couldn't write fields of templates: " + e.getMessage(), e);
        }
    }
}

