/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.TemplateType;
import net.sourceforge.javadpkg.TemplateTypeParser;
import net.sourceforge.javadpkg.impl.TemplateTypeUnsupportedWarning;

public class TemplateTypeParserImpl
implements TemplateTypeParser {
    private static final String KEY_SELECT = "select";
    private static final String KEY_MULTISELECT = "multiselect";
    private Map<String, TemplateType> types = new TreeMap<String, TemplateType>();

    public TemplateTypeParserImpl() {
        this.addType("string");
        this.addType(KEY_SELECT);
        this.addType(KEY_MULTISELECT);
        this.addType("boolean");
        this.addType("note");
        this.addType("text");
        this.addType("password");
        this.addType("error");
        this.addType("title");
    }

    private void addType(String text) {
        this.types.put(text, new TemplateTypeImpl(text));
    }

    @Override
    public TemplateType parseTemplateType(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        TemplateType type = this.types.get(value);
        if (type == null) {
            context.addWarning(new TemplateTypeUnsupportedWarning(value));
            type = new TemplateTypeImpl(value);
        }
        return type;
    }

    @Override
    public TemplateType getTypeSelect() {
        return this.types.get(KEY_SELECT);
    }

    @Override
    public TemplateType getTypeMultiselect() {
        return this.types.get(KEY_MULTISELECT);
    }

    private class TemplateTypeImpl
    implements TemplateType {
        private String text;

        public TemplateTypeImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

