/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Symbols;
import net.sourceforge.javadpkg.SymbolsParser;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldParser;
import net.sourceforge.javadpkg.field.impl.FieldParserImpl;
import net.sourceforge.javadpkg.impl.SymbolsEntryImpl;
import net.sourceforge.javadpkg.impl.SymbolsImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;

public class SymbolsParserImpl
implements SymbolsParser,
GlobalConstants {
    private PackageVersionParser packageVersionParser = new PackageVersionParserImpl();
    private PackageDependencyParser packageDependencyParser = new PackageDependencyParserImpl(new PackageNameParserImpl(), new PackageVersionRelationOperatorParserImpl(), this.packageVersionParser);
    private FieldParser fieldParser = new FieldParserImpl(false, false, false);

    @Override
    public Symbols parseSymbols(DataSource source, Context context) throws IOException, ParseException {
        SymbolsImpl symbols = null;
        boolean contentParsed = false;
        SymbolsEntryImpl entry = null;
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        symbols = new SymbolsImpl();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("| ")) {
                    if (entry == null) {
                        throw new ParseException("Symbol line |" + line + "| of symbols from source |" + source.getName() + "| contains an alternative dependency template also no initial line of an entry has been read.");
                    }
                    if (contentParsed) {
                        throw new ParseException("Symbol line |" + line + "| of symbols from source |" + source.getName() + "| contains an alternative dependency template also symbols have been already read.");
                    }
                    this.parseAlternativeDependencyTemplate(source, entry, line);
                    continue;
                }
                if (line.startsWith(" ")) {
                    if (entry == null) {
                        throw new ParseException("Symbol line |" + line + "| of symbols from source |" + source.getName() + "| contains a symbol also no initial line of an entry has been read.");
                    }
                    this.parseSymbol(source, context, entry, line);
                    contentParsed = true;
                    continue;
                }
                if (line.startsWith("* ")) {
                    if (entry == null) {
                        throw new ParseException("Symbol line |" + line + "| of symbols from source |" + source.getName() + "| contains a meta data field also no initial line of an entry has been read.");
                    }
                    this.parseMetaData(source, context, entry, line);
                    contentParsed = true;
                    continue;
                }
                entry = this.parseInitialLine(source, context, line);
                symbols.addEntry(entry);
                contentParsed = false;
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read the shared libraries from source |" + source.getName() + "|: " + e.getMessage());
        }
        if (entry == null) {
            throw new ParseException("The shared libraries from source |" + source.getName() + "| were empty.");
        }
        return symbols;
    }

    private SymbolsEntryImpl parseInitialLine(DataSource source, Context context, String line) throws ParseException {
        PackageDependency dependency = null;
        String[] parts = line.split(" ", 2);
        if (parts.length != 2) {
            throw new ParseException("Couldn't split line |" + line + "| of symbols from source |" + source.getName() + "| into 3 parts. Got " + parts.length);
        }
        String libraryName = parts[0];
        String dependencyTemplate = parts[1];
        if (!dependencyTemplate.endsWith("#MINVER#")) {
            try {
                dependency = this.packageDependencyParser.parsePackageDependency(dependencyTemplate, context);
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse dependency |" + dependencyTemplate + "| from |" + line + "| of symbols from source |" + source.getName() + "| into 3 parts. Got " + parts.length);
            }
        }
        SymbolsEntryImpl entry = dependency == null ? new SymbolsEntryImpl(libraryName, dependencyTemplate) : new SymbolsEntryImpl(libraryName, dependency);
        return entry;
    }

    private void parseAlternativeDependencyTemplate(DataSource source, SymbolsEntryImpl entry, String line) throws ParseException {
        String alternativeDependencyTemplate = line.substring(2);
        entry.setAlternativeDependencyValue(alternativeDependencyTemplate);
    }

    private void parseSymbol(DataSource source, Context context, SymbolsEntryImpl entry, String line) throws ParseException {
        PackageVersion version;
        String[] parts = line.trim().split(" ", 3);
        if (parts.length < 2 || parts.length > 3) {
            throw new ParseException("Couldn't split line |" + line + "| of symbols from source |" + source.getName() + "| into 2 or 3 parts. Got " + parts.length);
        }
        try {
            version = this.packageVersionParser.parsePackageVersion(parts[1], context);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse version |" + parts[1] + "| from |" + line + "| of symbols from source |" + source.getName() + "|: " + e.getMessage(), e);
        }
        parts = parts[0].split("@", 2);
        if (parts.length != 2) {
            throw new ParseException("Couldn't split |" + line + "| of symbols from source |" + source.getName() + "| into 2 parts. Got " + parts.length);
        }
        String symbolName = parts[0];
        String symbolVersion = parts[1];
        entry.addSymbol(symbolName, symbolVersion, version);
    }

    private void parseMetaData(DataSource source, Context context, SymbolsEntryImpl entry, String line) throws ParseException {
        List<Field> fields;
        String trimmedLine = line.substring(2);
        try (DataStreamSource fieldSource = new DataStreamSource(new ByteArrayInputStream(trimmedLine.getBytes()), "field", false);){
            fields = this.fieldParser.parseFieldsAsList(fieldSource, context);
        }
        catch (IOException | ParseException e) {
            throw new ParseException("Couldn't parse meta data field in line |" + line + "| of symbols from source |" + source.getName() + "|: " + e.getMessage(), e);
        }
        if (fields.isEmpty()) {
            throw new ParseException("Couldn't parse meta data field in line |" + line + "| of symbols from source |" + source.getName() + "|: Didn't find any field.");
        }
        Field field = fields.get(0);
        switch (field.getName().toLowerCase()) {
            case "build-depends-package": {
                PackageDependency dependency;
                try {
                    dependency = this.packageDependencyParser.parsePackageDependency(field.getValue(), context);
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse meta data field |" + field.getName() + "| in line |" + line + "| of symbols from source |" + source.getName() + "|: " + e.getMessage(), e);
                }
                entry.setBuildDependsPackage(dependency);
                break;
            }
            default: {
                throw new ParseException("Found unsupported meta data field |" + field.getName() + "| in line |" + line + "| of symbols from source |" + source.getName() + "|.");
            }
        }
    }
}

