/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.SymbolsEntry;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageVersion;

public class SymbolsEntryImpl
implements SymbolsEntry {
    private String libraryName;
    private String dependencyValue;
    private PackageDependency dependency;
    private String alternativeDependencyValue;
    private List<Symbol> symbols;
    private PackageDependency buildDependsPackage;

    private SymbolsEntryImpl(String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument libraryName is null.");
        }
        this.libraryName = libraryName;
        this.dependencyValue = null;
        this.dependency = null;
        this.alternativeDependencyValue = null;
        this.symbols = new ArrayList<Symbol>();
    }

    public SymbolsEntryImpl(String libraryName, String dependencyValue) {
        this(libraryName);
        if (dependencyValue == null) {
            throw new IllegalArgumentException("Argument dependencyValue is null.");
        }
        this.dependencyValue = dependencyValue;
    }

    public SymbolsEntryImpl(String libraryName, PackageDependency dependency) {
        this(libraryName);
        if (dependency == null) {
            throw new IllegalArgumentException("Argument dependency is null.");
        }
        this.dependency = dependency;
    }

    public void setAlternativeDependencyValue(String alternativeDependencyValue) {
        this.alternativeDependencyValue = alternativeDependencyValue;
    }

    public void addSymbol(String name, String version, PackageVersion upstreamVersion) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument version is null.");
        }
        if (upstreamVersion == null) {
            throw new IllegalArgumentException("Argument upstreamVersion is null.");
        }
        Symbol symbol = new Symbol(name, version, upstreamVersion);
        this.symbols.add(symbol);
    }

    public void setBuildDependsPackage(PackageDependency buildDependsPackage) {
        this.buildDependsPackage = buildDependsPackage;
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.libraryName);
        sb.append(' ');
        if (this.dependency == null) {
            sb.append(this.dependencyValue);
        }
        if (this.alternativeDependencyValue != null) {
            sb.append("\n| ");
            sb.append(this.alternativeDependencyValue);
        }
        if (this.symbols.isEmpty()) {
            sb.append('\n');
        } else {
            for (Symbol symbol : this.symbols) {
                sb.append("\n ");
                sb.append(symbol.getName());
                sb.append('@');
                sb.append(symbol.getVersion());
                sb.append(' ');
                sb.append(symbol.getUpstreamVersion().getText());
            }
        }
        if (this.buildDependsPackage != null) {
            // empty if block
        }
        return sb.toString();
    }

    private class Symbol {
        private String name;
        private String version;
        private PackageVersion upstreamVersion;

        public Symbol(String name, String version, PackageVersion upstreamVersion) {
            this.name = name;
            this.version = version;
            this.upstreamVersion = upstreamVersion;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public PackageVersion getUpstreamVersion() {
            return this.upstreamVersion;
        }
    }
}

