/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.SharedLibraries;
import net.sourceforge.javadpkg.SharedLibrariesParser;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.impl.SharedLibrariesImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class SharedLibrariesParserImpl
implements SharedLibrariesParser,
GlobalConstants {
    private PackageDependencyParser packageDependencyParser = new PackageDependencyParserImpl(new PackageNameParserImpl(), new PackageVersionRelationOperatorParserImpl(), new PackageVersionParserImpl());

    @Override
    public SharedLibraries parseSharedLibraries(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        SharedLibrariesImpl sharedLibraries = new SharedLibrariesImpl();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                List<PackageDependency> dependencies;
                int index;
                String type;
                String[] parts = line.split("[ \\t]+", 3);
                if (parts.length != 3) {
                    throw new ParseException("Couldn't split line |" + line + "| of shared libraries from source |" + source.getName() + "| into 3 parts. Got " + parts.length);
                }
                if (parts[0].endsWith(":")) {
                    parts = line.split("[ \\t]+", 4);
                    type = parts[0].substring(0, parts[0].length() - 1);
                    index = 1;
                } else {
                    type = null;
                    index = 0;
                }
                String libraryName = parts[index++];
                String version = parts[index++];
                try {
                    dependencies = this.packageDependencyParser.parsePackageDependencies(parts[index], context);
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse the package dependencies of line |" + line + "| of shared libraries from source |" + source.getName() + "|: " + e.getMessage(), e);
                }
                sharedLibraries.addSharedLibrary(type, libraryName, version, dependencies);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read the shared libraries from source |" + source.getName() + "|: " + e.getMessage());
        }
        return sharedLibraries;
    }
}

