/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.SharedLibraries;
import net.sourceforge.javadpkg.control.PackageDependency;

public class SharedLibrariesImpl
implements SharedLibraries {
    private List<SharedLibrary> sharedLibraries = new ArrayList<SharedLibrary>();

    public void addSharedLibrary(String type, String libraryName, String version, List<PackageDependency> dependencies) {
        if (libraryName == null) {
            throw new IllegalArgumentException("Argument libraryName is null.");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument version is null.");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Argument dependencies is null.");
        }
        SharedLibrary sharedLibrary = new SharedLibrary(type, libraryName, version, dependencies);
        this.sharedLibraries.add(sharedLibrary);
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (SharedLibrary lib : this.sharedLibraries) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (lib.getType() != null) {
                sb.append(lib.getType());
                sb.append(':');
            }
            sb.append(' ');
            sb.append(lib.getLibraryName());
            sb.append(' ');
            sb.append(lib.getVersion());
            sb.append(' ');
        }
        return sb.toString();
    }

    private class SharedLibrary {
        private String type;
        private String libraryName;
        private String version;
        private List<PackageDependency> dependencies;

        public SharedLibrary(String type, String libraryName, String version, List<PackageDependency> dependencies) {
            this.type = type;
            this.libraryName = libraryName;
            this.version = version;
            this.dependencies = new ArrayList<PackageDependency>(dependencies);
        }

        public String getType() {
            return this.type;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getVersion() {
            return this.version;
        }

        public List<PackageDependency> getDependencies() {
            return new ArrayList<PackageDependency>(this.dependencies);
        }
    }
}

