/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.MD5Sums;
import net.sourceforge.javadpkg.MD5SumsParser;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.impl.MD5SumsImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class MD5SumsParserImpl
implements MD5SumsParser,
GlobalConstants {
    @Override
    public MD5Sums parseMD5Sums(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        MD5SumsImpl md5Sums = new MD5SumsImpl();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(" ", 2);
                if (parts.length != 2) {
                    throw new ParseException("The line |" + line + "| doesn't consist of a MD5 sum part and a file path part.");
                }
                String md5sum = parts[0];
                if (!md5sum.matches("[a-f0-9]{32}")) {
                    throw new ParseException("The MD5 sums |" + md5sum + "| of the line |" + line + "| is not a valid MD5 sum.");
                }
                String path = parts[1];
                md5Sums.addMD5Sum(md5sum, path);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read MD5 sums from source |" + source.getName() + "|: " + e.getMessage());
        }
        return md5Sums;
    }
}

