/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.MD5SumsBuilder;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.store.DataStore;
import net.sourceforge.javadpkg.store.FileHash;

public class MD5SumsBuilderImpl
implements MD5SumsBuilder,
GlobalConstants {
    @Override
    public void buildMD5Sums(DataStore store, DataTarget target) throws IOException, BuildException {
        List<FileHash> fileHashes;
        MessageDigest digest;
        if (store == null) {
            throw new IllegalArgumentException("Argument store is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException("Couldn't build MD5 sums: MD5 is not supported: " + e.getMessage(), e);
        }
        try {
            fileHashes = store.createFileHashes(digest);
        }
        catch (IOException e) {
            throw new IOException("Couldn't build MD5 sums: Couldn't create hashes: " + e.getMessage(), e);
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8_CHARSET));){
            for (FileHash fileHash : fileHashes) {
                out.write(fileHash.getHashAsHex());
                out.write(" ");
                String path = fileHash.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                out.write(path);
                out.write("\n");
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't build MD5 sums: Couldn't write MD5 sums: " + e.getMessage(), e);
        }
    }
}

