/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.DocumentPaths;
import net.sourceforge.javadpkg.control.PackageName;

public class DocumentPathsImpl
implements DocumentPaths,
DebianPackageConstants {
    private String documentBasePath;
    private String documentPath;
    private String copyrightPath;
    private String changeLogPath;
    private String changeLogDebianPath;
    private String changeLogGzipPath;
    private String changeLogHtmlPath;
    private String changeLogHtmlGzipPath;

    public DocumentPathsImpl(PackageName name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.initialize("/usr/share/doc/", name);
    }

    private void initialize(String docBasePath, PackageName name) {
        this.documentBasePath = docBasePath;
        this.documentPath = docBasePath + name.getName() + "/";
        this.copyrightPath = this.documentPath + "copyright";
        this.changeLogPath = this.documentPath + "changelog";
        this.changeLogDebianPath = this.changeLogPath + ".Debian";
        this.changeLogGzipPath = this.changeLogPath + ".gz";
        this.changeLogHtmlPath = this.changeLogPath + ".html";
        this.changeLogHtmlGzipPath = this.changeLogHtmlPath + ".gz";
    }

    @Override
    public String getDocumentBasePath() {
        return this.documentBasePath;
    }

    @Override
    public String getDocumentPath() {
        return this.documentPath;
    }

    @Override
    public boolean isCopyrightPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        return this.copyrightPath.equals(path);
    }

    @Override
    public String getCopyrightPath() {
        return this.copyrightPath;
    }

    @Override
    public boolean isChangeLogPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        return path.equals(this.changeLogPath) || path.startsWith(this.changeLogPath + ".");
    }

    @Override
    public boolean isChangeLogDebianPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        return path.equals(this.changeLogDebianPath) || path.startsWith(this.changeLogDebianPath + ".");
    }

    @Override
    public boolean isChangeLogGzipPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!this.isChangeLogPath(path)) {
            return false;
        }
        return path.endsWith(".gz");
    }

    @Override
    public boolean isChangeLogHtmlPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!this.isChangeLogPath(path)) {
            return false;
        }
        int index = path.lastIndexOf(47);
        String name = path.substring(index + 1);
        if (name.isEmpty()) {
            return false;
        }
        index = name.indexOf(46);
        if (index == -1) {
            return false;
        }
        String extension = name.substring(index + 1);
        if (extension.isEmpty()) {
            return false;
        }
        return "html".equals(extension) || extension.startsWith("html.");
    }

    @Override
    public String getChangeLogPath() {
        return this.changeLogPath;
    }

    @Override
    public String getChangeLogGzipPath() {
        return this.changeLogGzipPath;
    }

    @Override
    public String getChangeLogHtmlPath() {
        return this.changeLogHtmlPath;
    }

    @Override
    public String getChangeLogHtmlGzipPath() {
        return this.changeLogHtmlGzipPath;
    }
}

