/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogParser;
import net.sourceforge.javadpkg.ConfigFilesParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightParser;
import net.sourceforge.javadpkg.DebianPackage;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.DebianPackageParseHandler;
import net.sourceforge.javadpkg.DebianPackageParser;
import net.sourceforge.javadpkg.DocumentPaths;
import net.sourceforge.javadpkg.MD5SumsParser;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.ScriptParser;
import net.sourceforge.javadpkg.SharedLibrariesParser;
import net.sourceforge.javadpkg.SymbolsParser;
import net.sourceforge.javadpkg.TemplatesParser;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.ControlParser;
import net.sourceforge.javadpkg.control.impl.ControlParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogParserImpl;
import net.sourceforge.javadpkg.impl.ConfigFilesParserImpl;
import net.sourceforge.javadpkg.impl.ControlUnsupportedEntryWarning;
import net.sourceforge.javadpkg.impl.CopyrightEmptyWarning;
import net.sourceforge.javadpkg.impl.CopyrightParserImpl;
import net.sourceforge.javadpkg.impl.DebianPackageImpl;
import net.sourceforge.javadpkg.impl.DocumentPathsImpl;
import net.sourceforge.javadpkg.impl.MD5SumsParserImpl;
import net.sourceforge.javadpkg.impl.ScriptParserImpl;
import net.sourceforge.javadpkg.impl.SharedLibrariesParserImpl;
import net.sourceforge.javadpkg.impl.SymbolsParserImpl;
import net.sourceforge.javadpkg.impl.TemplatesParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMetaData;
import net.sourceforge.javadpkg.io.impl.DataStreamSource;
import net.sourceforge.javadpkg.io.impl.FileMetaDataImpl;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.io.impl.UncloseableInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;

public class DebianPackageParserImpl
implements DebianPackageParser,
DebianPackageConstants {
    private ControlParser controlParser = new ControlParserImpl();
    private MD5SumsParser md5SumsParser = new MD5SumsParserImpl();
    private ScriptParser scriptParser = new ScriptParserImpl();
    private TemplatesParser templatesParser = new TemplatesParserImpl();
    private ConfigFilesParser configFilesParser = new ConfigFilesParserImpl();
    private SharedLibrariesParser sharedLibrariesParser = new SharedLibrariesParserImpl();
    private SymbolsParser symbolsParser = new SymbolsParserImpl();
    private CopyrightParser copyrightParser = new CopyrightParserImpl();
    private ChangeLogParser changeLogParser = new ChangeLogParserImpl();

    protected DebianPackageParserImpl() {
    }

    @Override
    public DebianPackage parseDebianPackage(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        DebianPackageParseHandlerImpl handler = new DebianPackageParseHandlerImpl();
        DebianPackage debianPackage = this.parseDebianPackage(source, handler, context);
        return debianPackage;
    }

    @Override
    public DebianPackage parseDebianPackage(DataSource source, DebianPackageParseHandler handler, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Argument handler is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        DebianPackageImpl debianPackage = new DebianPackageImpl();
        try (InputStream in = source.getInputStream();
             ArArchiveInputStream arIn = new ArArchiveInputStream(in);){
            this.readVersion(debianPackage, source, arIn);
            this.readControl(debianPackage, source, context, arIn);
            this.readData(handler, debianPackage, source, context, arIn);
        }
        return debianPackage;
    }

    private void readVersion(DebianPackageImpl debianPackage, DataSource source, ArArchiveInputStream in) throws IOException, ParseException {
        String line;
        ArArchiveEntry entry = in.getNextArEntry();
        if (!"debian-binary".equals(entry.getName())) {
            throw new ParseException("Couldn't find entry |debian-binary| in AR archive |" + source.getName() + "|: " + entry.getName());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new UncloseableInputStream((InputStream)in), UTF_8_CHARSET));){
            line = reader.readLine();
        }
        catch (IOException e) {
            throw new IOException("Couldn't read entry |" + entry.getName() + "| from AR archive |" + source.getName() + "|: " + e.getMessage());
        }
        if (line == null) {
            throw new ParseException("Couldn't read content of |debian-binary| in AR archive |" + source.getName() + "|.");
        }
        debianPackage.setFileFormatVersion(line);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readControl(DebianPackageImpl debianPackage, DataSource source, Context context, ArArchiveInputStream in) throws IOException, ParseException {
        control = null;
        md5Sums = null;
        preInstall = null;
        postInstall = null;
        preRemove = null;
        postRemove = null;
        config = null;
        templates = null;
        configFiles = null;
        sharedLibraries = null;
        symbols = null;
        entry = in.getNextArEntry();
        if (!entry.getName().startsWith("control.tar.")) {
            throw new ParseException("Couldn't find entry |control.tar.*| in AR archive |" + source.getName() + "|. Found |" + entry.getName() + "| instead.");
        }
        try {
            tarIn = this.openTarArchive((InputStream)in, entry.getName());
            var20_19 = null;
lbl18:
            // 12 sources

            while (true) {
                ** try [egrp 1[TRYBLOCK] [56, 57 : 119->2646)] { 
lbl20:
                // 1 sources

                break;
lbl21:
                // 1 sources

                catch (Throwable var21_24) {
                    var20_19 = var21_24;
                    throw var21_24;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read entry |" + entry.getName() + "| from AR archive |" + source.getName() + "|: " + e.getMessage());
        }
        block126: while ((tarEntry = tarIn.getNextTarEntry()) != null) {
            name = tarEntry.getName();
            if (name.startsWith("./")) {
                name = name.substring(2);
            }
            if (name.isEmpty()) continue;
            var21_22 = name;
            var22_25 = -1;
            switch (var21_22.hashCode()) {
                case 951543133: {
                    if (!var21_22.equals("control")) break;
                    var22_25 = 0;
                    break;
                }
                case 869057030: {
                    if (!var21_22.equals("md5sums")) break;
                    var22_25 = 1;
                    break;
                }
                case -318566551: {
                    if (!var21_22.equals("preinst")) break;
                    var22_25 = 2;
                    break;
                }
                case 757640934: {
                    if (!var21_22.equals("postinst")) break;
                    var22_25 = 3;
                    break;
                }
                case 106931230: {
                    if (!var21_22.equals("prerm")) break;
                    var22_25 = 4;
                    break;
                }
                case -982450469: {
                    if (!var21_22.equals("postrm")) break;
                    var22_25 = 5;
                    break;
                }
                case 1981727545: {
                    if (!var21_22.equals("templates")) break;
                    var22_25 = 6;
                    break;
                }
                case -1354792126: {
                    if (!var21_22.equals("config")) break;
                    var22_25 = 7;
                    break;
                }
                case -807149101: {
                    if (!var21_22.equals("conffiles")) break;
                    var22_25 = 8;
                    break;
                }
                case -903247261: {
                    if (!var21_22.equals("shlibs")) break;
                    var22_25 = 9;
                    break;
                }
                case -1743438373: {
                    if (!var21_22.equals("symbols")) break;
                    var22_25 = 10;
                    break;
                }
            }
            switch (var22_25) {
                case 0: {
                    if (control != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    control = this.controlParser.parseControl(entrySource, context);
                    debianPackage.setControl(control);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl96
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_29) {
                        var24_27.addSuppressed(var25_29);
                    }
                    continue block126;
lbl96:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_30) {
                        try {
                            var24_27 = var25_30;
                            throw var25_30;
                        }
                        catch (Throwable var26_51) {
                            if (entrySource == null) throw var26_51;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var26_51;
                            }
                            try {
                                entrySource.close();
                                throw var26_51;
                            }
                            catch (Throwable var27_52) {
                                var24_27.addSuppressed(var27_52);
                                throw var26_51;
                            }
                        }
                    }
                }
                case 1: {
                    if (md5Sums != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    md5Sums = this.md5SumsParser.parseMD5Sums(entrySource, context);
                    debianPackage.setMD5Sums(md5Sums);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl129
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_31) {
                        var24_27.addSuppressed(var25_31);
                    }
                    continue block126;
lbl129:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_32) {
                        try {
                            var24_27 = var25_32;
                            throw var25_32;
                        }
                        catch (Throwable var28_53) {
                            if (entrySource == null) throw var28_53;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var28_53;
                            }
                            try {
                                entrySource.close();
                                throw var28_53;
                            }
                            catch (Throwable var29_54) {
                                var24_27.addSuppressed(var29_54);
                                throw var28_53;
                            }
                        }
                    }
                }
                case 2: {
                    if (preInstall != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    preInstall = this.scriptParser.parseScript(entrySource, context);
                    debianPackage.setPreInstall(preInstall);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl162
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_33) {
                        var24_27.addSuppressed(var25_33);
                    }
                    continue block126;
lbl162:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_34) {
                        try {
                            var24_27 = var25_34;
                            throw var25_34;
                        }
                        catch (Throwable var30_55) {
                            if (entrySource == null) throw var30_55;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var30_55;
                            }
                            try {
                                entrySource.close();
                                throw var30_55;
                            }
                            catch (Throwable var31_56) {
                                var24_27.addSuppressed(var31_56);
                                throw var30_55;
                            }
                        }
                    }
                }
                case 3: {
                    if (postInstall != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    postInstall = this.scriptParser.parseScript(entrySource, context);
                    debianPackage.setPostInstall(postInstall);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl195
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_35) {
                        var24_27.addSuppressed(var25_35);
                    }
                    continue block126;
lbl195:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_36) {
                        try {
                            var24_27 = var25_36;
                            throw var25_36;
                        }
                        catch (Throwable var32_57) {
                            if (entrySource == null) throw var32_57;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var32_57;
                            }
                            try {
                                entrySource.close();
                                throw var32_57;
                            }
                            catch (Throwable var33_58) {
                                var24_27.addSuppressed(var33_58);
                                throw var32_57;
                            }
                        }
                    }
                }
                case 4: {
                    if (preRemove != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    preRemove = this.scriptParser.parseScript(entrySource, context);
                    debianPackage.setPreRemove(preRemove);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl228
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_37) {
                        var24_27.addSuppressed(var25_37);
                    }
                    continue block126;
lbl228:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_38) {
                        try {
                            var24_27 = var25_38;
                            throw var25_38;
                        }
                        catch (Throwable var34_59) {
                            if (entrySource == null) throw var34_59;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var34_59;
                            }
                            try {
                                entrySource.close();
                                throw var34_59;
                            }
                            catch (Throwable var35_60) {
                                var24_27.addSuppressed(var35_60);
                                throw var34_59;
                            }
                        }
                    }
                }
                case 5: {
                    if (postRemove != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    postRemove = this.scriptParser.parseScript(entrySource, context);
                    debianPackage.setPostRemove(postRemove);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl261
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_39) {
                        var24_27.addSuppressed(var25_39);
                    }
                    continue block126;
lbl261:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_40) {
                        try {
                            var24_27 = var25_40;
                            throw var25_40;
                        }
                        catch (Throwable var36_61) {
                            if (entrySource == null) throw var36_61;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var36_61;
                            }
                            try {
                                entrySource.close();
                                throw var36_61;
                            }
                            catch (Throwable var37_62) {
                                var24_27.addSuppressed(var37_62);
                                throw var36_61;
                            }
                        }
                    }
                }
                case 6: {
                    if (templates != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    templates = this.templatesParser.parseTemplates(entrySource, context);
                    debianPackage.setTemplates(templates);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl294
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_41) {
                        var24_27.addSuppressed(var25_41);
                    }
                    continue block126;
lbl294:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_42) {
                        try {
                            var24_27 = var25_42;
                            throw var25_42;
                        }
                        catch (Throwable var38_63) {
                            if (entrySource == null) throw var38_63;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var38_63;
                            }
                            try {
                                entrySource.close();
                                throw var38_63;
                            }
                            catch (Throwable var39_64) {
                                var24_27.addSuppressed(var39_64);
                                throw var38_63;
                            }
                        }
                    }
                }
                case 7: {
                    if (config != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    config = this.scriptParser.parseScript(entrySource, context);
                    debianPackage.setConfig(config);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl327
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_43) {
                        var24_27.addSuppressed(var25_43);
                    }
                    continue block126;
lbl327:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_44) {
                        try {
                            var24_27 = var25_44;
                            throw var25_44;
                        }
                        catch (Throwable var40_65) {
                            if (entrySource == null) throw var40_65;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var40_65;
                            }
                            try {
                                entrySource.close();
                                throw var40_65;
                            }
                            catch (Throwable var41_66) {
                                var24_27.addSuppressed(var41_66);
                                throw var40_65;
                            }
                        }
                    }
                }
                case 8: {
                    if (configFiles != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    configFiles = this.configFilesParser.parseConfigFiles(entrySource, context);
                    debianPackage.setConfigFiles(configFiles);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl360
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_45) {
                        var24_27.addSuppressed(var25_45);
                    }
                    continue block126;
lbl360:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_46) {
                        try {
                            var24_27 = var25_46;
                            throw var25_46;
                        }
                        catch (Throwable var42_67) {
                            if (entrySource == null) throw var42_67;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var42_67;
                            }
                            try {
                                entrySource.close();
                                throw var42_67;
                            }
                            catch (Throwable var43_68) {
                                var24_27.addSuppressed(var43_68);
                                throw var42_67;
                            }
                        }
                    }
                }
                case 9: {
                    if (sharedLibraries != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    sharedLibraries = this.sharedLibrariesParser.parseSharedLibraries(entrySource, context);
                    debianPackage.setSharedLibraries(sharedLibraries);
                    if (entrySource == null) ** GOTO lbl18
                    if (var24_27 == null) ** GOTO lbl393
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_47) {
                        var24_27.addSuppressed(var25_47);
                    }
                    continue block126;
lbl393:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_48) {
                        try {
                            var24_27 = var25_48;
                            throw var25_48;
                        }
                        catch (Throwable var44_69) {
                            if (entrySource == null) throw var44_69;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var44_69;
                            }
                            try {
                                entrySource.close();
                                throw var44_69;
                            }
                            catch (Throwable var45_70) {
                                var24_27.addSuppressed(var45_70);
                                throw var44_69;
                            }
                        }
                    }
                }
                case 10: {
                    if (symbols != null) {
                        throw new ParseException("Found entry |" + name + "| in archive |" + entry.getName() + "| in source |" + source.getName() + "| more than one time.");
                    }
                    entrySource = new DataStreamSource((InputStream)tarIn, name, false);
                    var24_27 = null;
                    symbols = this.symbolsParser.parseSymbols(entrySource, context);
                    debianPackage.setSymbols(symbols);
                    if (entrySource == null) ** continue;
                    if (var24_27 == null) ** GOTO lbl426
                    try {
                        entrySource.close();
                    }
                    catch (Throwable var25_49) {
                        var24_27.addSuppressed(var25_49);
                    }
                    continue block126;
lbl426:
                    // 1 sources

                    entrySource.close();
                    continue block126;
                    catch (Throwable var25_50) {
                        try {
                            var24_27 = var25_50;
                            throw var25_50;
                        }
                        catch (Throwable var46_71) {
                            if (entrySource == null) throw var46_71;
                            if (var24_27 == null) {
                                entrySource.close();
                                throw var46_71;
                            }
                            try {
                                entrySource.close();
                                throw var46_71;
                            }
                            catch (Throwable var47_72) {
                                var24_27.addSuppressed(var47_72);
                                throw var46_71;
                            }
                        }
                    }
                }
            }
            context.addWarning(new ControlUnsupportedEntryWarning(name));
        }
        return;
lbl446:
        // 1 sources

        finally {
            if (tarIn != null) {
                if (var20_19 != null) {
                    try {
                        tarIn.close();
                    }
                    catch (Throwable var21_23) {
                        var20_19.addSuppressed(var21_23);
                    }
                } else {
                    tarIn.close();
                }
            }
        }
    }

    private void readData(DebianPackageParseHandler handler, DebianPackageImpl debianPackage, DataSource source, Context context, ArArchiveInputStream in) throws IOException, ParseException {
        String name = null;
        boolean changeLogDebianRead = false;
        ArArchiveEntry entry = in.getNextArEntry();
        if (!entry.getName().startsWith("data.tar.")) {
            throw new ParseException("Couldn't find entry |data.tar.*| in AR archive |" + source.getName() + "|. Found |" + entry.getName() + "| instead.");
        }
        if (!(debianPackage.getControl() instanceof BinaryControl)) {
            throw new ParseException("Found control |" + debianPackage.getControl() + "| of type |" + (debianPackage.getControl() == null ? "null" : debianPackage.getControl().getClass().getCanonicalName()) + ", but only control of type |" + BinaryControl.class.getCanonicalName() + "| is supported.");
        }
        BinaryControl control = (BinaryControl)debianPackage.getControl();
        DocumentPathsImpl paths = new DocumentPathsImpl(control.getPackage());
        ArrayList<String> names = new ArrayList<String>();
        try (TarArchiveInputStream tarIn = this.openTarArchive((InputStream)in, entry.getName());){
            TarArchiveEntry tarEntry;
            while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                FileMetaData file;
                name = tarEntry.getName();
                names.add(name);
                if (name.startsWith(".")) {
                    name = name.substring(1);
                }
                FileOwnerImpl owner = new FileOwnerImpl(tarEntry.getLongGroupId(), tarEntry.getGroupName(), tarEntry.getLongUserId(), tarEntry.getUserName());
                FileModeImpl mode = new FileModeImpl(tarEntry.getMode());
                if (tarEntry.isDirectory()) {
                    file = FileMetaDataImpl.createDirectoryMetaData(name, owner, mode, tarEntry.getLastModifiedDate());
                } else if (tarEntry.isFile()) {
                    file = FileMetaDataImpl.createFileMetaData(name, owner, mode, tarEntry.getSize(), tarEntry.getLastModifiedDate());
                } else if (tarEntry.isSymbolicLink()) {
                    file = FileMetaDataImpl.createSymbolicLinkMetaData(name, tarEntry.getLinkName(), owner, mode, tarEntry.getLastModifiedDate());
                } else {
                    throw new IOException("Entry |" + name + "| is |" + this.getEntryType(tarEntry) + "| entry, but only entries of te types directory, file and symbolic link are supported.");
                }
                if (file.isFile() && !file.isSymbolicLink() && (paths.isCopyrightPath(name) || paths.isChangeLogPath(name))) {
                    if (paths.isCopyrightPath(name)) {
                        if (debianPackage.getCopyright() != null) {
                            throw new ParseException("Copyright is already set.");
                        }
                        Copyright copyright = this.readCopyright((InputStream)tarIn, name, context);
                        debianPackage.setCopyright(copyright);
                    } else if (paths.isChangeLogPath(name)) {
                        if (tarEntry.getSize() > 0L) {
                            if (debianPackage.getChangeLog() != null) {
                                if (changeLogDebianRead && !paths.isChangeLogDebianPath(name)) {
                                    name = null;
                                    continue;
                                }
                                if (!paths.isChangeLogDebianPath(name)) {
                                    throw new ParseException("Change log is already set.");
                                }
                            }
                            ChangeLog changeLog = this.readChangeLog((InputStream)tarIn, name, paths, context);
                            debianPackage.setChangeLog(changeLog);
                            if (paths.isChangeLogDebianPath(name)) {
                                changeLogDebianRead = true;
                            }
                        } else {
                            context.addWarning(new CopyrightEmptyWarning());
                        }
                    } else if (!name.endsWith("/changelog-old.Debian.gz")) {
                        throw new ParseException("Unsupported copyright or change log file: " + name);
                    }
                } else if (file.isDirectory() || file.isSymbolicLink()) {
                    handler.handleData(file, null);
                } else {
                    try (DataStreamSource entrySource = new DataStreamSource((InputStream)tarIn, name, false);){
                        handler.handleData(file, entrySource);
                    }
                }
                name = null;
            }
        }
        catch (IOException e) {
            if (name == null) {
                throw new IOException("Couldn't read AR archive entry |" + entry.getName() + "| from AR archive |" + source.getName() + "| (Read TAR archive entries:" + (names.isEmpty() ? " No entries" : names.stream().collect(Collectors.joining("|,\n|", "\n|", "|\n"))) + "): " + e.getMessage(), e);
            }
            throw new IOException("Couldn't read AR archive entry |" + entry.getName() + "| from AR archive |" + source.getName() + "|: Couldn't process TAR archive entry |" + name + "| (Read TAR archive entries:" + (names.isEmpty() ? " No entries" : names.stream().collect(Collectors.joining("|,\n|", "\n|", "|\n"))) + "): " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse TAR archive entry |" + name + "| of AR archive entry |" + entry.getName() + "| from AR archive |" + source.getName() + "|: " + e.getMessage(), e);
        }
    }

    private String getEntryType(TarArchiveEntry entry) {
        if (entry.isBlockDevice()) {
            return "block device";
        }
        if (entry.isCharacterDevice()) {
            return "character device";
        }
        if (entry.isDirectory()) {
            return "directory";
        }
        if (entry.isFIFO()) {
            return "FIFO";
        }
        if (entry.isLink()) {
            return "link";
        }
        if (entry.isSymbolicLink()) {
            return "symbolic link";
        }
        return "unknown";
    }

    private Copyright readCopyright(InputStream in, String name, Context context) throws IOException, ParseException {
        Copyright copyright;
        try (DataStreamSource fileSource = new DataStreamSource(in, name, false);){
            copyright = this.copyrightParser.parseCopyright(fileSource, context);
        }
        return copyright;
    }

    private ChangeLog readChangeLog(InputStream in, String name, DocumentPaths paths, Context context) throws IOException, ParseException {
        ChangeLog changeLog;
        if (paths.isChangeLogGzipPath(name)) {
            try (GZIPInputStream gzipIn = new GZIPInputStream(new UncloseableInputStream(in));){
                DataStreamSource fileSource;
                if (paths.isChangeLogHtmlPath(name)) {
                    fileSource = new DataStreamSource(gzipIn, name, false);
                    Throwable throwable = null;
                    try {
                        changeLog = this.changeLogParser.parseChangeLogHtml(fileSource, context);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileSource != null) {
                            if (throwable != null) {
                                try {
                                    fileSource.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                fileSource.close();
                            }
                        }
                    }
                }
                fileSource = new DataStreamSource(gzipIn, name, false);
                Throwable throwable = null;
                try {
                    changeLog = this.changeLogParser.parseChangeLog(fileSource, context);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fileSource != null) {
                        if (throwable != null) {
                            try {
                                fileSource.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            fileSource.close();
                        }
                    }
                }
            }
        } else {
            if (paths.isChangeLogHtmlPath(name)) {
                try (DataStreamSource fileSource = new DataStreamSource(in, name, false);){
                    changeLog = this.changeLogParser.parseChangeLogHtml(fileSource, context);
                }
            }
            try (DataStreamSource fileSource = new DataStreamSource(in, name, false);){
                changeLog = this.changeLogParser.parseChangeLog(fileSource, context);
            }
        }
        return changeLog;
    }

    private TarArchiveInputStream openTarArchive(InputStream in, String name) throws IOException {
        GzipCompressorInputStream compressorIn;
        UncloseableInputStream uncloseIn = new UncloseableInputStream(in);
        if (name.endsWith(".tar.gz")) {
            compressorIn = new GzipCompressorInputStream((InputStream)uncloseIn);
        } else if (name.endsWith(".tar.xz")) {
            compressorIn = new XZCompressorInputStream((InputStream)uncloseIn);
        } else if (name.endsWith(".tar.bz2")) {
            compressorIn = new BZip2CompressorInputStream((InputStream)uncloseIn);
        } else {
            throw new IOException("Found entry |" + name + "| with unsupported compression.");
        }
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)compressorIn, StandardCharsets.UTF_8.name());
        return tarIn;
    }

    private class DebianPackageParseHandlerImpl
    implements DebianPackageParseHandler {
        @Override
        public void handleData(FileMetaData metaData, DataSource source) throws IOException, ParseException {
            if (metaData == null) {
                throw new IllegalArgumentException("Argument metaData is null.");
            }
            if (metaData.isFile() && source == null) {
                throw new IllegalArgumentException("Argument source for file |" + metaData.getAbsolutePath() + "| is null also the file is a regular file.");
            }
        }
    }
}

