/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogBuilder;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightBuilder;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.MD5SumsBuilder;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptBuilder;
import net.sourceforge.javadpkg.ScriptVariableReplacer;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.ControlBuilder;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.control.impl.ControlBuilderImpl;
import net.sourceforge.javadpkg.impl.ChangeLogBuilderImpl;
import net.sourceforge.javadpkg.impl.CopyrightBuilderImpl;
import net.sourceforge.javadpkg.impl.DocumentPathsImpl;
import net.sourceforge.javadpkg.impl.MD5SumsBuilderImpl;
import net.sourceforge.javadpkg.impl.ScriptBuilderImpl;
import net.sourceforge.javadpkg.impl.ScriptVariableReplacerImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import net.sourceforge.javadpkg.io.impl.DataTempFileSwap;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.ReplacementsMap;
import net.sourceforge.javadpkg.store.DataStore;
import net.sourceforge.javadpkg.store.DataStoreImpl;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class DebianPackageBuilderImpl
implements DebianPackageBuilder,
DebianPackageConstants {
    private static final String FILE_FORMAT_VERSION = "2.0";
    private Script defaultPreInstall;
    private Script defaultPostInstall;
    private Script defaultPreRemove;
    private Script defaultPostRemove;
    private ControlBuilder controlBuilder;
    private MD5SumsBuilder md5SumsBuilder;
    private ScriptBuilder scriptBuilder;
    private ScriptVariableReplacer scriptVariableReplacer;
    private CopyrightBuilder copyrightBuilder;
    private ChangeLogBuilder changeLogBuilder;
    private Control control;
    private Size installedSizeOverhead;
    private Script preInstall;
    private Script postInstall;
    private Script preRemove;
    private Script postRemove;
    private DataStore dataStore;
    private Copyright copyright;
    private ChangeLog changeLog;

    protected DebianPackageBuilderImpl(Script defaultPreInstall, Script defaultPostInstall, Script defaultPreRemove, Script defaultPostRemove) {
        if (defaultPreInstall == null) {
            throw new IllegalArgumentException("Argument defaultPreInstall is null.");
        }
        if (defaultPostInstall == null) {
            throw new IllegalArgumentException("Argument defaultPostInstall is null.");
        }
        if (defaultPreRemove == null) {
            throw new IllegalArgumentException("Argument defaultPreRemove is null.");
        }
        if (defaultPostRemove == null) {
            throw new IllegalArgumentException("Argument defaultPostRemove is null.");
        }
        this.defaultPreInstall = defaultPreInstall;
        this.defaultPostInstall = defaultPostInstall;
        this.defaultPreRemove = defaultPreRemove;
        this.defaultPostRemove = defaultPostRemove;
        this.controlBuilder = new ControlBuilderImpl();
        this.md5SumsBuilder = new MD5SumsBuilderImpl();
        this.scriptBuilder = new ScriptBuilderImpl();
        this.scriptVariableReplacer = new ScriptVariableReplacerImpl();
        this.copyrightBuilder = new CopyrightBuilderImpl();
        this.changeLogBuilder = new ChangeLogBuilderImpl();
        this.control = null;
        this.installedSizeOverhead = null;
        this.preInstall = null;
        this.postInstall = null;
        this.preRemove = null;
        this.postRemove = null;
        this.dataStore = new DataStoreImpl();
        this.copyright = null;
        this.changeLog = null;
    }

    @Override
    public void setControl(Control control) {
        this.control = control;
    }

    @Override
    public void setInstalledSizeOverhead(Size installedSizeOverhead) {
        this.installedSizeOverhead = installedSizeOverhead;
    }

    @Override
    public void setPreInstall(Script preInstall) {
        this.preInstall = preInstall;
    }

    @Override
    public void setPostInstall(Script postInstall) {
        this.postInstall = postInstall;
    }

    @Override
    public void setPreRemove(Script preRemove) {
        this.preRemove = preRemove;
    }

    @Override
    public void setPostRemove(Script postRemove) {
        this.postRemove = postRemove;
    }

    @Override
    public void addDataDirectory(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        this.dataStore.addDirectory(path);
    }

    @Override
    public void addDataDirectory(String path, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.dataStore.addDirectory(path, owner, mode);
    }

    @Override
    public void addDataFile(DataSource source, String path) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        this.dataStore.addFile(source, path);
    }

    @Override
    public void addDataFile(DataSource source, String path, FileOwner owner, FileMode mode) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.dataStore.addFile(source, path, owner, mode);
    }

    @Override
    public void addDataSymLink(String path, String target, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.dataStore.addSymLink(path, target, owner, mode);
    }

    @Override
    public void setCopyright(Copyright copyright) {
        this.copyright = copyright;
    }

    @Override
    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    @Override
    public void buildDebianPackage(DataTarget target, Context context) throws IOException, BuildException {
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (this.control == null) {
            throw new IllegalStateException("Can't build Debian package because no control information is set.");
        }
        if (this.copyright == null) {
            throw new IllegalStateException("Can't build Debian package because no copyright is set.");
        }
        if (this.changeLog == null) {
            throw new IllegalStateException("Can't build Debian package because no change log is set.");
        }
        try (OutputStream out = target.getOutputStream();
             ArArchiveOutputStream arOut = new ArArchiveOutputStream(out);){
            this.writeVersion(target, arOut);
            this.writeControl(target, context, arOut);
            this.writeData(target, context, arOut);
        }
    }

    private void writeVersion(DataTarget target, ArArchiveOutputStream out) throws IOException {
        try {
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)arrayOut, UTF_8_CHARSET));){
                writer.write(FILE_FORMAT_VERSION);
                writer.write(10);
            }
            byte[] data = arrayOut.toByteArray();
            ArArchiveEntry entry = new ArArchiveEntry("debian-binary", (long)data.length);
            out.putArchiveEntry((ArchiveEntry)entry);
            out.write(data);
            out.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new IOException("Couldn't write |debian-binary| in AR archive |" + target.getName() + "|: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeControl(DataTarget target, Context context, ArArchiveOutputStream out) throws IOException, BuildException {
        Size installedSize = null;
        boolean deleted = false;
        if (this.control instanceof BinaryControl) {
            installedSize = ((BinaryControl)this.control).getInstalledSize();
        }
        if (installedSize == null) {
            try {
                installedSize = this.dataStore.getSize();
            }
            catch (IOException e) {
                throw new IOException("Couldn't determine size of all files which should be added to the Debian package: " + e.getMessage(), e);
            }
        }
        if (this.installedSizeOverhead != null) {
            installedSize = new Size(installedSize.getBytes() + this.installedSizeOverhead.getBytes());
        }
        File controlFile = File.createTempFile("control", ".tar.gz");
        try {
            try (FileOutputStream fileOut = new FileOutputStream(controlFile);
                 TarArchiveOutputStream tarOut = this.createTarArchive(fileOut);){
                this.writeTarEntry(tarOut, "", 0L, "root", 0L, "root", 493, null);
                try (DataTempFileSwap swap = new DataTempFileSwap("control");){
                    this.controlBuilder.buildControl(this.control, installedSize, swap.getTarget(), context);
                    this.writeTarEntry(tarOut, "control", 0L, "root", 0L, "root", 420, swap.getSource());
                }
                swap = new DataTempFileSwap("md5sums");
                var13_17 = null;
                try {
                    this.md5SumsBuilder.buildMD5Sums(this.dataStore, swap.getTarget());
                    this.writeTarEntry(tarOut, "md5sums", 0L, "root", 0L, "root", 420, swap.getSource());
                }
                catch (Throwable throwable) {
                    var13_17 = throwable;
                    throw throwable;
                }
                finally {
                    if (swap != null) {
                        if (var13_17 != null) {
                            try {
                                swap.close();
                            }
                            catch (Throwable throwable) {
                                var13_17.addSuppressed(throwable);
                            }
                        } else {
                            swap.close();
                        }
                    }
                }
                if (this.control instanceof BinaryControl) {
                    PackageVersion version = ((BinaryControl)this.control).getVersion();
                    this.writeScript(tarOut, this.preInstall, this.defaultPreInstall, "preinst", version, context);
                    this.writeScript(tarOut, this.postInstall, this.defaultPostInstall, "postinst", version, context);
                    this.writeScript(tarOut, this.preRemove, this.defaultPreRemove, "prerm", version, context);
                    this.writeScript(tarOut, this.postRemove, this.defaultPostRemove, "postrm", version, context);
                }
            }
            this.writeArEntry(out, "control.tar.gz", controlFile);
        }
        finally {
            deleted = !controlFile.exists() || controlFile.delete();
        }
        if (!deleted) {
            throw new IOException("Couldn't delete temporary control file |" + controlFile.getAbsolutePath() + "|.");
        }
    }

    private void writeScript(TarArchiveOutputStream out, Script script, Script defaultScript, String name, PackageVersion version, Context context) throws IOException, BuildException {
        Script effectiveScript;
        if (script == null) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("deb.version", version.getText());
            ReplacementsMap replacements = new ReplacementsMap(variables);
            try {
                effectiveScript = this.scriptVariableReplacer.replaceScriptVariables(defaultScript, replacements, context);
            }
            catch (ReplacementException e) {
                throw new BuildException("Couldn't write default script |" + name + "|: " + e.getMessage(), e);
            }
        } else {
            effectiveScript = script;
        }
        try (DataTempFileSwap swap = new DataTempFileSwap(name);){
            this.scriptBuilder.buildScript(swap.getTarget(), effectiveScript);
            this.writeTarEntry(out, name, 0L, "root", 0L, "root", 493, swap.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(DataTarget target, Context context, ArArchiveOutputStream out) throws IOException, BuildException {
        String[] ensurePaths;
        boolean deleted = false;
        DataTempFileSwap swapCopyright = null;
        Closeable swapChangeLog = null;
        if (!(this.control instanceof BinaryControl)) {
            throw new BuildException("Found control |" + this.control + "| of type |" + (this.control == null ? "null" : this.control.getClass().getCanonicalName()) + ", but only control of type |" + BinaryControl.class.getCanonicalName() + "| is supported.");
        }
        BinaryControl control = (BinaryControl)this.control;
        DocumentPathsImpl paths = new DocumentPathsImpl(control.getPackage());
        if (this.dataStore.exists(paths.getCopyrightPath())) {
            throw new BuildException("Found |" + paths.getCopyrightPath() + " added to the builder, but the copyright should be added through the corresponding method of the builder.");
        }
        if (this.dataStore.exists(paths.getChangeLogPath())) {
            throw new BuildException("Found |" + paths.getChangeLogPath() + " added to the builder, but the copyright should be added through the corresponding method of the builder.");
        }
        if (this.dataStore.exists(paths.getChangeLogGzipPath())) {
            throw new BuildException("Found |" + paths.getChangeLogGzipPath() + " added to the builder, but the copyright should be added through the corresponding method of the builder.");
        }
        if (this.dataStore.exists(paths.getChangeLogHtmlPath())) {
            throw new BuildException("Found |" + paths.getChangeLogHtmlPath() + " added to the builder, but the copyright should be added through the corresponding method of the builder.");
        }
        if (this.dataStore.exists(paths.getChangeLogHtmlGzipPath())) {
            throw new BuildException("Found |" + paths.getChangeLogHtmlGzipPath() + " added to the builder, but the copyright should be added through the corresponding method of the builder.");
        }
        for (String ensurePath : ensurePaths = new String[]{"/usr/", "/usr/share/", paths.getDocumentBasePath(), paths.getDocumentPath()}) {
            if (this.dataStore.exists(ensurePath)) continue;
            this.dataStore.addDirectory(ensurePath);
        }
        File dataFile = File.createTempFile("data", ".tar.gz");
        try {
            swapCopyright = new DataTempFileSwap("copyright");
            this.copyrightBuilder.buildCopyright(this.copyright, swapCopyright.getTarget(), context);
            this.dataStore.addFile(swapCopyright.getSource(), paths.getCopyrightPath());
            try (DataTempFileSwap swap = new DataTempFileSwap("changelog");){
                this.changeLogBuilder.buildChangeLog(this.changeLog, swap.getTarget(), context);
                swapChangeLog = new DataTempFileSwap("changelog.gz");
                Streams.compressGzip(swap.getSource(), swapChangeLog.getTarget(), 9);
            }
            this.dataStore.addFile(swapChangeLog.getSource(), paths.getChangeLogGzipPath());
            var12_12 = null;
            try (FileOutputStream fileOut = new FileOutputStream(dataFile);
                 TarArchiveOutputStream tarOut = this.createTarArchive(fileOut);){
                this.dataStore.write(tarOut);
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            this.writeArEntry(out, "data.tar.gz", dataFile);
        }
        finally {
            swapChangeLog.close();
            swapCopyright.close();
            deleted = !dataFile.exists() || dataFile.delete();
        }
        if (!deleted) {
            throw new IOException("Couldn't delete temporary data file |" + dataFile.getAbsolutePath() + "|.");
        }
    }

    private TarArchiveOutputStream createTarArchive(OutputStream out) throws IOException {
        GzipParameters gzipParameters = new GzipParameters();
        gzipParameters.setCompressionLevel(9);
        GzipCompressorOutputStream compressorOut = new GzipCompressorOutputStream(out, gzipParameters);
        TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)compressorOut);
        tarOut.setLongFileMode(2);
        return tarOut;
    }

    private void writeTarEntry(TarArchiveOutputStream out, String name, long groupId, String groupName, long userId, String userName, int mode, DataSource source) throws IOException {
        block23: {
            StringBuilder entryName = new StringBuilder();
            if (!name.startsWith("./")) {
                entryName.append('.');
                if (!name.startsWith("/")) {
                    entryName.append('/');
                }
            }
            entryName.append(name);
            TarArchiveEntry tarEntry = new TarArchiveEntry(entryName.toString());
            tarEntry.setGroupId(groupId);
            tarEntry.setGroupName(groupName);
            tarEntry.setUserId(userId);
            tarEntry.setUserName(userName);
            tarEntry.setMode(mode);
            if (source != null) {
                if (source.getLength() < 0L) {
                    throw new IOException("Couldn't create entry |" + name + "| in TAR archive stream: Couldn't determine size of source |" + source.getName() + "|.");
                }
                tarEntry.setSize(source.getLength());
            }
            try {
                out.putArchiveEntry((ArchiveEntry)tarEntry);
            }
            catch (IOException e) {
                throw new IOException("Couldn't create entry |" + name + "| in TAR archive stream: " + e.getMessage(), e);
            }
            if (source != null) {
                try {
                    if (source.getLength() <= 0L) break block23;
                    try (DataStreamTarget target = new DataStreamTarget((OutputStream)out, name, false);){
                        Streams.copy(source, target);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Couldn't create entry |" + name + "| in TAR archive stream: " + e.getMessage(), e);
                }
            }
        }
        try {
            out.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new IOException("Couldn't create entry |" + name + "| in TAR archive stream: " + e.getMessage(), e);
        }
    }

    private void writeArEntry(ArArchiveOutputStream out, String name, File file) throws IOException {
        try {
            ArArchiveEntry entry = new ArArchiveEntry(name, file.length());
            out.putArchiveEntry((ArchiveEntry)entry);
            try (InputStream in = Streams.createBufferedFileInputStream(file);){
                Streams.copy(in, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new IOException("Couldn't write file |" + file.getAbsolutePath() + "| as entry |" + name + "| into the archive stream: " + e.getMessage(), e);
        }
    }
}

