/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.DebianPackageBuilderFactory;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.ScriptParser;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.DebianPackageBuilderImpl;
import net.sourceforge.javadpkg.impl.ScriptParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.Streams;

public class DebianPackageBuilderFactoryImpl
implements DebianPackageBuilderFactory {
    private ScriptParser scriptParser = new ScriptParserImpl();
    private Script defaultPreInstall;
    private Script defaultPostInstall;
    private Script defaultPreRemove;
    private Script defaultPostRemove;

    public DebianPackageBuilderFactoryImpl() throws IOException, ParseException {
        this.initialize();
    }

    private void initialize() throws IOException, ParseException {
        ContextImpl context = new ContextImpl();
        try (DataSource source = Streams.createResourceDataSource(this.getClass(), "preinst");){
            this.defaultPreInstall = this.scriptParser.parseScript(source, context);
        }
        source = Streams.createResourceDataSource(this.getClass(), "postinst");
        var3_3 = null;
        try {
            this.defaultPostInstall = this.scriptParser.parseScript(source, context);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (source != null) {
                if (var3_3 != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    source.close();
                }
            }
        }
        source = Streams.createResourceDataSource(this.getClass(), "prerm");
        var3_3 = null;
        try {
            this.defaultPreRemove = this.scriptParser.parseScript(source, context);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (source != null) {
                if (var3_3 != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    source.close();
                }
            }
        }
        source = Streams.createResourceDataSource(this.getClass(), "postrm");
        var3_3 = null;
        try {
            this.defaultPostRemove = this.scriptParser.parseScript(source, context);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (source != null) {
                if (var3_3 != null) {
                    try {
                        source.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    source.close();
                }
            }
        }
    }

    @Override
    public DebianPackageBuilder createDebianPackageBuilder() {
        DebianPackageBuilderImpl builder = new DebianPackageBuilderImpl(this.defaultPreInstall, this.defaultPostInstall, this.defaultPreRemove, this.defaultPostRemove);
        return builder;
    }
}

