/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightConstants;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.CopyrightParser;
import net.sourceforge.javadpkg.FilesCopyright;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldParser;
import net.sourceforge.javadpkg.field.impl.FieldParserImpl;
import net.sourceforge.javadpkg.impl.CopyrightImpl;
import net.sourceforge.javadpkg.impl.CopyrightLicenseImpl;
import net.sourceforge.javadpkg.impl.CopyrightUnsupportedFieldWarning;
import net.sourceforge.javadpkg.impl.CopyrightUnsupportedFormatWarning;
import net.sourceforge.javadpkg.impl.FilesCopyrightImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class CopyrightParserImpl
implements CopyrightParser,
CopyrightConstants {
    private FieldParser fieldParser = new FieldParserImpl(true, true, true);
    private boolean strictFieldNames = false;

    @Override
    public Copyright parseCopyright(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        List<Field> fields = this.parseFields(source, context);
        Copyright copyright = this.parseCopyright(fields, context);
        return copyright;
    }

    private List<Field> parseFields(DataSource source, Context context) throws IOException, ParseException {
        List<Field> fields;
        try {
            fields = this.fieldParser.parseFieldsAsList(source, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't parse fields of copyright: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse fields of copyright: " + e.getMessage(), e);
        }
        return fields;
    }

    private Copyright parseCopyright(List<Field> fields, Context context) throws ParseException {
        CopyrightImpl copyright = null;
        boolean header = true;
        CopyrightLicenseImpl license = null;
        FilesCopyrightImpl filesCopyright = null;
        ArrayList<FilesCopyright> filesCopyrights = new ArrayList<FilesCopyright>();
        LinkedHashMap<String, CopyrightLicense> licenses = new LinkedHashMap<String, CopyrightLicense>();
        for (Field field : fields) {
            if (header) {
                if (field.isEmpty()) {
                    if (copyright == null) continue;
                    header = false;
                    continue;
                }
                if (field.isNameless()) {
                    if (copyright == null) {
                        context.addWarning(new CopyrightUnsupportedFormatWarning());
                        break;
                    }
                    throw new ParseException("Found nameless field |" + field.getValue() + "| in the header of the copyright.");
                }
                if (this.isField(field, "Format")) {
                    copyright = new CopyrightImpl();
                    copyright.setFormat(field.getValue());
                    if ("http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/".equals(copyright.getFormat())) continue;
                    context.addWarning(new CopyrightUnsupportedFormatWarning(copyright.getFormat()));
                    break;
                }
                if (copyright == null) {
                    context.addWarning(new CopyrightUnsupportedFormatWarning());
                    break;
                }
                if (this.isField(field, "Upstream-Name")) {
                    copyright.setUpstreamName(field.getValue());
                    continue;
                }
                if (this.isField(field, "Upstream-Contact")) {
                    copyright.setUpstreamContact(field.getValue());
                    continue;
                }
                if (this.isField(field, "Source")) {
                    copyright.setSource(field.getValue());
                    continue;
                }
                if (this.isField(field, "Disclaimer")) {
                    copyright.setDisclaimer(field.getValue());
                    continue;
                }
                if (this.isField(field, "Comment")) {
                    copyright.setComment(field.getValue());
                    continue;
                }
                if (this.isField(field, "License")) {
                    license = this.parseLicense(field);
                    copyright.setLicense(license);
                    license = null;
                    continue;
                }
                if (this.isField(field, "Copyright")) {
                    copyright.setCopyright(field.getValue());
                    continue;
                }
                context.addWarning(new CopyrightUnsupportedFieldWarning(field.getName(), field.getValue()));
                continue;
            }
            if (copyright == null) {
                throw new ParseException("Read empty line in copyright instead of header field.");
            }
            if (field.isEmpty()) {
                filesCopyright = null;
                license = null;
                continue;
            }
            if (field.isNameless()) {
                throw new ParseException("Found nameless field |" + field.getValue() + "| in the content of the copyright.");
            }
            if (this.isField(field, "Files")) {
                if (license != null) {
                    throw new ParseException("Read files copyright |" + field.getValue() + "| without read an empty line before it.");
                }
                if (filesCopyright == null) {
                    filesCopyright = this.parseFiles(field, null);
                    filesCopyrights.add(filesCopyright);
                    continue;
                }
                this.parseFiles(field, filesCopyright);
                continue;
            }
            if (this.isField(field, "Copyright")) {
                if (license != null) {
                    throw new ParseException("Read copyright field |" + field.getValue() + "| for license |" + license.getName() + "|, but this field type is not supported for a license.");
                }
                if (filesCopyright == null) {
                    filesCopyright = new FilesCopyrightImpl();
                    filesCopyrights.add(filesCopyright);
                }
                filesCopyright.setCopyright(field.getValue());
                continue;
            }
            if (this.isField(field, "License")) {
                if (filesCopyright != null) {
                    license = this.parseLicense(field);
                    filesCopyright.setLicense(license);
                    license = null;
                    continue;
                }
                if (license != null) {
                    throw new ParseException("Read license |" + field.getValue() + "| without read an empty line before it.");
                }
                license = this.parseLicense(field);
                if (licenses.put(license.getName(), license) == null) continue;
                throw new ParseException("Read license |" + license.getName() + "| more than one time.");
            }
            if (!this.isField(field, "Comment")) continue;
            if (license != null) {
                license.setComment(field.getValue());
                continue;
            }
            if (filesCopyright != null) {
                filesCopyright.setComment(field.getValue());
                continue;
            }
            throw new ParseException("Found comment field |" + field.getValue() + "| outside of a license or files copyright.");
        }
        if (copyright == null) {
            copyright = new CopyrightImpl();
        } else {
            copyright.setFilesCopyrights(filesCopyrights);
            copyright.setLicenses(licenses);
        }
        return copyright;
    }

    private CopyrightLicenseImpl parseLicense(Field field) {
        String value = field.getFormattedValue();
        String[] lines = value.split("\n", -1);
        CopyrightLicenseImpl license = new CopyrightLicenseImpl();
        license.setName(lines[0]);
        if (lines.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int index = 1; index < lines.length; ++index) {
                String line = lines[index];
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(line);
            }
            license.setText(sb.toString());
        }
        return license;
    }

    private FilesCopyrightImpl parseFiles(Field field, FilesCopyrightImpl filesCopyright) {
        FilesCopyrightImpl fc = filesCopyright == null ? new FilesCopyrightImpl() : filesCopyright;
        List<String> patterns = this.parsePatterns(field.getValue());
        fc.setFiles(patterns);
        return fc;
    }

    private List<String> parsePatterns(String value) {
        String[] patterns = value.split("[\\n ]", -1);
        return Arrays.asList(patterns);
    }

    private boolean isField(Field field, String name) {
        boolean match = field.getName() == null ? false : (this.strictFieldNames ? name.equals(field.getName()) : name.equalsIgnoreCase(field.getName()));
        return match;
    }
}

