/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.CopyrightBuilder;
import net.sourceforge.javadpkg.CopyrightConstants;
import net.sourceforge.javadpkg.CopyrightLicense;
import net.sourceforge.javadpkg.FilesCopyright;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldBuilder;
import net.sourceforge.javadpkg.field.impl.EmptyField;
import net.sourceforge.javadpkg.field.impl.FieldBuilderImpl;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.io.DataTarget;

public class CopyrightBuilderImpl
implements CopyrightBuilder,
CopyrightConstants {
    private FieldBuilder fieldBuilder = new FieldBuilderImpl();

    @Override
    public void buildCopyright(Copyright copyright, DataTarget target, Context context) throws IOException, BuildException {
        if (copyright == null) {
            throw new IllegalArgumentException("Argument copyright is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        List<Field> fields = this.buildFields(copyright);
        this.buildCopyright(fields, target, context);
    }

    private List<Field> buildFields(Copyright copyright) throws BuildException {
        String format = copyright.getFormat();
        if (format == null) {
            format = "http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/";
        } else if (!"http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/".equals(format)) {
            throw new BuildException("The format of the copyright is |" + format + "|, but only the format |" + "http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/" + "| is supported by the builder.");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addField(fields, "Format", format, false);
        this.addField(fields, "Upstream-Name", copyright.getUpstreamName(), false);
        this.addField(fields, "Upstream-Contact", copyright.getUpstreamContact(), false);
        this.addField(fields, "Source", copyright.getSource(), false);
        this.addField(fields, "Disclaimer", copyright.getDisclaimer(), false);
        this.addField(fields, "Comment", copyright.getComment(), false);
        this.addField(fields, "License", copyright.getLicense());
        this.addField(fields, "Copyright", copyright.getCopyright(), false);
        for (FilesCopyright filesCopyright : copyright.getFilesCopyrights()) {
            fields.add(EmptyField.EMPTY_FIELD);
            this.addField(fields, "Files", filesCopyright.getFiles());
            this.addField(fields, "Copyright", filesCopyright.getCopyright(), false);
            this.addField(fields, "License", filesCopyright.getLicense());
            this.addField(fields, "Comment", filesCopyright.getComment(), false);
        }
        for (Map.Entry entry : copyright.getLicenses().entrySet()) {
            fields.add(EmptyField.EMPTY_FIELD);
            this.addField(fields, "License", (CopyrightLicense)entry.getValue());
            if (((CopyrightLicense)entry.getValue()).getComment() == null) continue;
            this.addField(fields, "Comment", ((CopyrightLicense)entry.getValue()).getComment(), false);
        }
        return fields;
    }

    private void addField(List<Field> fields, String name, String value, boolean formatValue) {
        if (value == null) {
            return;
        }
        FieldImpl field = new FieldImpl(name, value, formatValue);
        fields.add(field);
    }

    private void addField(List<Field> fields, String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(value);
        }
        this.addField(fields, name, sb.toString(), false);
    }

    private void addField(List<Field> fields, String name, CopyrightLicense license) {
        if (license == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(license.getName());
        if (license.getText() != null) {
            sb.append('\n');
            sb.append(license.getText());
        }
        this.addField(fields, name, sb.toString(), true);
    }

    private void buildCopyright(List<Field> fields, DataTarget target, Context context) throws IOException, BuildException {
        try {
            this.fieldBuilder.buildFields(fields, target, context);
        }
        catch (IOException e) {
            throw new IOException("Couldn't build copyright |" + target.getName() + "|: " + e.getMessage());
        }
        catch (BuildException e) {
            throw new BuildException("Couldn't build copyright |" + target.getName() + "|: " + e.getMessage());
        }
    }
}

