/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Warning;

public class ContextImpl
implements Context {
    private List<Warning> warnings = new ArrayList<Warning>();
    private ReadWriteLock warningsLock = new ReentrantReadWriteLock();

    @Override
    public void addWarning(Warning warning) {
        if (warning == null) {
            throw new IllegalArgumentException("Argument warning is null.");
        }
        this.warningsLock.writeLock().lock();
        try {
            this.warnings.add(warning);
        }
        finally {
            this.warningsLock.writeLock().unlock();
        }
    }

    @Override
    public List<Warning> getWarnings() {
        ArrayList<Warning> result;
        this.warningsLock.readLock().lock();
        try {
            result = new ArrayList<Warning>(this.warnings);
        }
        finally {
            this.warningsLock.readLock().unlock();
        }
        return result;
    }
}

