/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.javadpkg.ConfigFiles;
import net.sourceforge.javadpkg.ConfigFilesParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.impl.ConfigFilesImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class ConfigFilesParserImpl
implements ConfigFilesParser,
GlobalConstants {
    @Override
    public ConfigFiles parseConfigFiles(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ConfigFilesImpl configFiles = new ConfigFilesImpl();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                configFiles.addPath(line);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read the configuration files from source |" + source.getName() + "|: " + e.getMessage());
        }
        return configFiles;
    }
}

