/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.ChangeLogUrgency;
import net.sourceforge.javadpkg.ChangeLogUrgencyParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.impl.ChangeLogUrgencyUnsupportedWarning;

public class ChangeLogUrgencyParserImpl
implements ChangeLogUrgencyParser {
    private Map<String, ChangeLogUrgency> urgency = new TreeMap<String, ChangeLogUrgency>();

    public ChangeLogUrgencyParserImpl() {
        this.addUrgency("low");
        this.addUrgency("medium");
        this.addUrgency("high");
        this.addUrgency("emergency");
        this.addUrgency("critical");
    }

    private void addUrgency(String text) {
        this.urgency.put(text.toLowerCase(), new ChangeLogUrgencyImpl(text));
    }

    @Override
    public ChangeLogUrgency parseChangeLogUrgency(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ChangeLogUrgency urgency = this.urgency.get(value.toLowerCase());
        if (urgency == null) {
            urgency = new ChangeLogUrgencyImpl(value);
            context.addWarning(new ChangeLogUrgencyUnsupportedWarning(value));
        }
        return urgency;
    }

    private class ChangeLogUrgencyImpl
    implements ChangeLogUrgency {
        private String text;

        public ChangeLogUrgencyImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

