/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogConstants;
import net.sourceforge.javadpkg.ChangeLogParser;
import net.sourceforge.javadpkg.ChangeLogUrgency;
import net.sourceforge.javadpkg.ChangeLogUrgencyParser;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogImpl;
import net.sourceforge.javadpkg.impl.ChangeLogInitialLineUnsupportedWarning;
import net.sourceforge.javadpkg.impl.ChangeLogUnsupportedLineWarning;
import net.sourceforge.javadpkg.impl.ChangeLogUrgencyParserImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryDetailImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class ChangeLogParserImpl
implements ChangeLogParser,
ChangeLogConstants {
    private PackageNameParser packageNameParser = new PackageNameParserImpl();
    private PackageVersionParser packageVersionParser = new PackageVersionParserImpl();
    private ChangeLogUrgencyParser changeLogUrgencyParser = new ChangeLogUrgencyParserImpl();
    private PackageMaintainerParser packageMaintainerParser = new PackageMaintainerParserImpl();

    @Override
    public ChangeLog parseChangeLog(DataSource source, Context context) throws IOException, ParseException {
        String line = null;
        int lineNumber = 0;
        ChangeLogVersionEntryImpl entry = null;
        StringBuilder sb = null;
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ChangeLogImpl changeLog = new ChangeLogImpl();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            while ((line = in.readLine()) != null) {
                ChangeLogVersionEntryDetailImpl detail;
                ++lineNumber;
                if ("#".equals(line) || line.startsWith("# ")) continue;
                if (entry == null) {
                    if (line.isEmpty() || line.trim().isEmpty()) continue;
                    entry = this.parseInitialLine(line, context);
                    if (entry == null) break;
                    changeLog.addEntry(entry);
                    continue;
                }
                if (line.startsWith(" -- ")) {
                    if (sb != null) {
                        detail = new ChangeLogVersionEntryDetailImpl(sb.toString());
                        entry.addDetail(detail);
                        sb = null;
                    }
                    this.parseTerminationLine(line, entry, context);
                    entry = null;
                    continue;
                }
                if (line.startsWith("  * ")) {
                    if (sb != null) {
                        detail = new ChangeLogVersionEntryDetailImpl(sb.toString());
                        entry.addDetail(detail);
                        sb = null;
                    }
                    sb = this.parseDetailLine(line, null, context);
                    continue;
                }
                if (line.startsWith("    ")) {
                    if (sb == null) {
                        context.addWarning(new ChangeLogUnsupportedLineWarning(line));
                        continue;
                    }
                    sb = this.parseDetailLine(line, sb, context);
                    continue;
                }
                if (line.isEmpty()) continue;
                context.addWarning(new ChangeLogUnsupportedLineWarning(line));
            }
            if (entry != null) {
                throw new ParseException("End of last version entry in the change log is missing.");
            }
            if (lineNumber == 0) {
                throw new ParseException("Change log is empty.");
            }
        }
        catch (IOException e) {
            throw new IOException("An error occurred while parsing source |" + source.getName() + "|: " + e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ParseException("Line |" + line + "| (Line number: " + lineNumber + ") couldn't be parsed: " + e.getMessage(), e);
        }
        return changeLog;
    }

    private ChangeLogVersionEntryImpl parseInitialLine(String line, Context context) throws ParseException {
        ChangeLogUrgency urgency;
        PackageVersion version;
        PackageName packageName;
        int index = line.indexOf(32);
        if (index == -1) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Didn't find first whitespace in the first line of the change log entry."));
            return null;
        }
        String value = line.substring(0, index);
        try {
            packageName = this.packageNameParser.parsePackageName(value, context);
        }
        catch (ParseException e) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't parser package name |" + value + "| of first line of change log entry: " + e.getMessage()));
            return null;
        }
        if (line.length() <= ++index) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "First line of change log entry is too short. Only found the package name."));
            return null;
        }
        if (line.charAt(index) != '(') {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't find the beginning of version of the package in the first line of change log entry."));
            return null;
        }
        ++index;
        int lastIndex = index;
        if ((index = line.indexOf(41, lastIndex)) == -1) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't find the end of version of the package in the first line of change log entry."));
            return null;
        }
        value = line.substring(lastIndex, index);
        try {
            version = this.packageVersionParser.parsePackageVersion(value, context);
        }
        catch (ParseException e) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't parser version |" + value + "| of first line of change log entry: " + e.getMessage()));
            return null;
        }
        lastIndex = index + 1;
        index = line.indexOf(59, lastIndex);
        if (index == -1) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't find the semi-colon between the distributions and the urgency in the first line of change log entry."));
            return null;
        }
        value = line.substring(lastIndex, index).trim();
        ArrayList<String> distributions = new ArrayList<String>(Arrays.asList(value.split(" ")));
        lastIndex = index + 1;
        value = line.substring(lastIndex).trim();
        if (!value.startsWith("urgency=")) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't the urgency prefix |urgency=| in the part |" + value + "| after the semi-colon in the first line of change log entry."));
            return null;
        }
        value = value.substring(8);
        try {
            urgency = this.changeLogUrgencyParser.parseChangeLogUrgency(value, context);
        }
        catch (ParseException e) {
            context.addWarning(new ChangeLogInitialLineUnsupportedWarning(line, "Couldn't parser urgency |" + value + "| of first line of change log entry: " + e.getMessage()));
            return null;
        }
        ChangeLogVersionEntryImpl entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(packageName);
        entry.setVersion(version);
        entry.setDistributions(distributions);
        entry.setUrgency(urgency);
        return entry;
    }

    private StringBuilder parseDetailLine(String line, StringBuilder detail, Context context) throws ParseException {
        StringBuilder sb = detail == null ? new StringBuilder() : detail;
        String value = line.substring(4);
        if (sb.length() > 0) {
            sb.append('\n');
        }
        if (!".".equals(value)) {
            sb.append(value);
        }
        return sb;
    }

    private void parseTerminationLine(String line, ChangeLogVersionEntryImpl entry, Context context) throws ParseException {
        Date date;
        PackageMaintainer maintainer;
        String rest = line.substring(" -- ".length());
        int index = rest.indexOf("  ");
        if (index == -1) {
            throw new ParseException("Couldn't parse last line |" + line + "| of change log entry as the separator between maintainer and timestamp couldn't be found.");
        }
        String value = rest.substring(0, index);
        try {
            maintainer = this.packageMaintainerParser.parsePackageMaintainer(value, context);
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parser maintainer |" + value + "| of last line of change log entry: " + e.getMessage(), e);
        }
        value = rest.substring(index + 2);
        try {
            date = TIMESTAMP_FORMAT.parse(value);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Couldn't parse timestamp |" + value + "| of last line of change log entry: " + e.getMessage(), e);
        }
        entry.setMaintainer(maintainer);
        entry.setDate(date);
    }

    @Override
    public ChangeLog parseChangeLogHtml(DataSource source, Context context) throws IOException, ParseException {
        throw new ParseException("Not yet implemented");
    }
}

