/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogBuilder;
import net.sourceforge.javadpkg.ChangeLogConstants;
import net.sourceforge.javadpkg.ChangeLogUrgencyBuilder;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.PackageMaintainerBuilder;
import net.sourceforge.javadpkg.control.PackageNameBuilder;
import net.sourceforge.javadpkg.control.PackageVersionBuilder;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionBuilderImpl;
import net.sourceforge.javadpkg.impl.ChangeLogUrgencyBuilderImpl;
import net.sourceforge.javadpkg.io.DataTarget;

public class ChangeLogBuilderImpl
implements ChangeLogBuilder,
ChangeLogConstants {
    private static final String NEWLINE = "\n";
    private PackageNameBuilder packageNameBuilder = new PackageNameBuilderImpl();
    private PackageVersionBuilder packageVersionBuilder = new PackageVersionBuilderImpl();
    private ChangeLogUrgencyBuilder changeLogUrgencyBuilder = new ChangeLogUrgencyBuilderImpl();
    private PackageMaintainerBuilder packageMaintainerBuilder = new PackageMaintainerBuilderImpl();

    @Override
    public void buildChangeLog(ChangeLog changeLog, DataTarget target, Context context) throws IOException, BuildException {
        boolean firstEntry = true;
        if (changeLog == null) {
            throw new IllegalArgumentException("Argument changeLog is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8_CHARSET));){
            for (ChangeLogVersionEntry entry : changeLog.getEntries()) {
                String version;
                String value;
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    out.write(NEWLINE);
                }
                try {
                    value = this.packageNameBuilder.buildPackageName(entry.getPackage(), context);
                }
                catch (BuildException e) {
                    throw new BuildException("Couldn't build change log |" + target.getName() + "| because package name couldn't be build: " + e.getMessage(), e);
                }
                out.write(value);
                out.write(" (");
                try {
                    version = this.packageVersionBuilder.buildPackageVersion(entry.getVersion(), context);
                }
                catch (BuildException e) {
                    throw new BuildException("Couldn't build change log |" + target.getName() + "| because version couldn't be build: " + e.getMessage(), e);
                }
                out.write(version);
                out.write(")");
                List<String> values = entry.getDistributions();
                if (values.isEmpty()) {
                    throw new IllegalArgumentException("Couldn't build change log |" + target.getName() + "| because no distribution was defined for version |" + version + "|.");
                }
                for (String v : values) {
                    out.write(" ");
                    out.write(v);
                }
                out.write("; urgency=");
                try {
                    value = this.changeLogUrgencyBuilder.buildChangeLogUrgency(entry.getUrgency(), context);
                }
                catch (BuildException e) {
                    throw new BuildException("Couldn't build change log |" + target.getName() + "| because urgency couldn't be build for version |" + version + "|: " + e.getMessage(), e);
                }
                out.write(value);
                out.write(NEWLINE);
                List<ChangeLogVersionEntryDetail> details = entry.getDetails();
                if (details.isEmpty()) {
                    throw new BuildException("Couldn't build change log |" + target.getName() + "| because no details are defined for version |" + version + "|.");
                }
                for (ChangeLogVersionEntryDetail detail : details) {
                    out.write(NEWLINE);
                    this.buildDetail(out, detail);
                }
                out.write(NEWLINE);
                try {
                    value = this.packageMaintainerBuilder.buildPackageMaintainer(entry.getMaintainer(), context);
                }
                catch (BuildException e) {
                    throw new BuildException("Couldn't build change log |" + target.getName() + "| because maintainer couldn't be build for version |" + version + "|: " + e.getMessage(), e);
                }
                out.write(" -- ");
                out.write(value);
                out.write("  ");
                value = TIMESTAMP_FORMAT.format(entry.getDate());
                out.write(value);
                out.write(NEWLINE);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't write change log |" + target.getName() + "|: " + e.getMessage(), e);
        }
    }

    private void buildDetail(Writer out, ChangeLogVersionEntryDetail detail) throws IOException {
        String[] lines;
        boolean firstLine = true;
        String text = detail.getText();
        for (String line : lines = text.split(NEWLINE, -1)) {
            if (firstLine) {
                out.write("  * ");
                firstLine = false;
            } else {
                out.write(NEWLINE);
                out.write("    ");
            }
            if (line.isEmpty()) {
                out.write(".");
                continue;
            }
            out.write(line);
        }
        out.write(NEWLINE);
    }

    @Override
    public void buildChangeLogHtml(ChangeLog changeLog, DataTarget target, Context context) throws IOException, BuildException {
        throw new BuildException("Not yet implemented");
    }
}

