/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldParser;
import net.sourceforge.javadpkg.field.impl.EmptyField;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.field.impl.NamelessField;
import net.sourceforge.javadpkg.io.DataSource;

public class FieldParserImpl
implements FieldParser,
GlobalConstants {
    private boolean allowEmptyLines;
    private boolean returnEmptyLines;
    private boolean allowNamelessFields;

    public FieldParserImpl(boolean allowEmptyLines, boolean returnEmptyLines, boolean allowNamelessFields) {
        this.allowEmptyLines = allowEmptyLines;
        this.returnEmptyLines = returnEmptyLines;
        this.allowNamelessFields = allowNamelessFields;
    }

    @Override
    public Map<String, Field> parseFieldsAsMap(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        List<Field> list = this.parseFieldsAsList(source, context);
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        for (Field field : list) {
            if (field.isEmpty() || field.isNameless()) continue;
            String name = field.getName().toLowerCase();
            if (map.containsKey(name)) {
                throw new ParseException("The field |" + field.getName() + "| exists more than one time in the source |" + source.getName() + "|.");
            }
            map.put(name, field);
        }
        return map;
    }

    @Override
    public List<Field> parseFieldsAsList(DataSource source, Context context) throws IOException, ParseException {
        FieldImpl field = null;
        boolean lastLine = false;
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream(), UTF_8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (lastLine) {
                    throw new ParseException("Found a line |" + line + "| in source |" + source.getName() + "| which is not a field.");
                }
                if (line.startsWith("#")) continue;
                if (line.startsWith(" ") || line.startsWith("\t")) {
                    if (field == null) {
                        if (this.allowNamelessFields) {
                            fields.add(new NamelessField(line));
                            continue;
                        }
                        throw new ParseException("Found a continuation line |" + line + "| in source |" + source.getName() + "|, but the initial line of the field is missing.");
                    }
                    field.addValue("\n");
                    line = line.substring(1);
                    field.addValue(line);
                    continue;
                }
                if (line.isEmpty()) {
                    if (!this.allowEmptyLines) {
                        lastLine = true;
                        continue;
                    }
                    if (!this.returnEmptyLines) continue;
                    fields.add(EmptyField.EMPTY_FIELD);
                    continue;
                }
                int index = line.indexOf(58);
                if (index == -1) {
                    if (this.allowNamelessFields) {
                        fields.add(new NamelessField(line));
                        continue;
                    }
                    throw new ParseException("Found a line |" + line + "| in source |" + source.getName() + "| which is not a field.");
                }
                String name = line.substring(0, index).trim();
                String value = line.substring(index + 1).trim();
                field = new FieldImpl(name, value);
                fields.add(field);
            }
        }
        catch (IOException e) {
            throw new IOException("Couldn't read control for Debian binary package from source |" + source.getName() + "|: " + e.getMessage(), e);
        }
        return fields;
    }
}

