/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import net.sourceforge.javadpkg.field.impl.AbstractField;

public class FieldImpl
extends AbstractField {
    private String name;
    private StringBuilder value;

    public FieldImpl(String name, String value) {
        this(name, value, false);
    }

    public FieldImpl(String name, String value, boolean formatValue) {
        super(false, false);
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        this.name = name;
        this.value = new StringBuilder();
        if (formatValue) {
            this.value.append(this.formatValue(value));
        } else {
            this.value.append(value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value.toString();
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        this.value = new StringBuilder();
        this.value.append(value);
    }

    public void addValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        this.value.append(value);
    }
}

