/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.GlobalConstants;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldBuilder;
import net.sourceforge.javadpkg.io.DataTarget;

public class FieldBuilderImpl
implements FieldBuilder,
GlobalConstants {
    @Override
    public void buildFields(List<Field> fields, DataTarget target, Context context) throws IOException, BuildException {
        if (fields == null) {
            throw new IllegalArgumentException("Argument fields is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (field.isEmpty()) continue;
            if (!field.isNameless()) {
                sb.append(field.getName());
                sb.append(": ");
            }
            String value = this.getFormattedValue(field.getValue());
            sb.append(value);
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8_CHARSET));){
            out.write(sb.toString());
        }
    }

    private String getFormattedValue(String value) {
        if (value.indexOf(10) == -1) {
            return value;
        }
        String[] values = value.split("\n", -1);
        StringBuilder sb = new StringBuilder();
        for (String v : values) {
            if (sb.length() > 0) {
                sb.append("\n ");
            }
            sb.append(v);
        }
        return sb.toString();
    }
}

