/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import net.sourceforge.javadpkg.field.Field;

public abstract class AbstractField
implements Field {
    private boolean nameless;
    private boolean empty;

    public AbstractField(boolean nameless, boolean empty) {
        this.nameless = nameless;
        this.empty = empty;
    }

    protected String formatValue(String value) {
        String[] lines;
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = value.split("\n", -1)) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (line.isEmpty()) {
                sb.append('.');
                continue;
            }
            sb.append(line);
        }
        return sb.toString();
    }

    @Override
    public boolean isNameless() {
        return this.nameless;
    }

    @Override
    public String getFormattedValue() {
        String[] lines;
        String value = this.getValue();
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = value.split("\n", -1)) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (".".equals(line)) continue;
            sb.append(line);
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }
}

