/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.control.SizeParser;

public class SizeParserImpl
implements SizeParser {
    @Override
    public Size parseSizeInKiloBytes(String value, Context context) throws ParseException {
        long v;
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        try {
            v = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParseException("The size |" + value + "| is not a valid long value representing a size in kilobytes.");
        }
        Size size = Size.getSizeInKiloBytes(v);
        return size;
    }
}

