/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Section;
import net.sourceforge.javadpkg.control.SectionParser;
import net.sourceforge.javadpkg.control.impl.SectionUnsupportedWarning;

public class SectionParserImpl
implements SectionParser {
    private Map<String, Section> sections = new TreeMap<String, Section>();

    public SectionParserImpl() {
        this.addSection("admin");
        this.addSection("contrib/utils");
        this.addSection("comm");
        this.addSection("database");
        this.addSection("devel");
        this.addSection("doc");
        this.addSection("editors");
        this.addSection("fonts");
        this.addSection("gnome");
        this.addSection("graphics");
        this.addSection("httpd");
        this.addSection("interpreters");
        this.addSection("introspection");
        this.addSection("java");
        this.addSection("kernel");
        this.addSection("libdevel");
        this.addSection("libs");
        this.addSection("localization");
        this.addSection("mail");
        this.addSection("math");
        this.addSection("metapackages");
        this.addSection("misc");
        this.addSection("net");
        this.addSection("non-free/misc");
        this.addSection("oldlibs");
        this.addSection("otherosfs");
        this.addSection("perl");
        this.addSection("php");
        this.addSection("python");
        this.addSection("science");
        this.addSection("shells");
        this.addSection("sound");
        this.addSection("text");
        this.addSection("utils");
        this.addSection("vcs");
        this.addSection("web");
        this.addSection("x11");
        this.addSection("zope");
    }

    private void addSection(String name) {
        this.sections.put(name, new SectionImpl(name));
    }

    @Override
    public Section parseSection(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        Section section = this.sections.get(value);
        if (section == null) {
            context.addWarning(new SectionUnsupportedWarning(value));
            section = new SectionImpl(value);
        }
        return section;
    }

    private class SectionImpl
    implements Section {
        private String name;

        public SectionImpl(String name) {
            this.name = name;
        }

        @Override
        public String getText() {
            return this.name;
        }
    }
}

