/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperator;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;

public class PackageVersionRelationOperatorParserImpl
implements PackageVersionRelationOperatorParser {
    private Map<String, PackageVersionRelationOperator> relationOperators = new TreeMap<String, PackageVersionRelationOperator>();

    public PackageVersionRelationOperatorParserImpl() {
        this.addRelationOperator("<<");
        this.addRelationOperator("<=");
        this.addRelationOperator("=");
        this.addRelationOperator(">=");
        this.addRelationOperator(">>");
    }

    private void addRelationOperator(String text) {
        this.relationOperators.put(text, new PackageVersionRelationOperatorImpl(text));
    }

    @Override
    public PackageVersionRelationOperator parsePackageVersionRelationOperator(String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        PackageVersionRelationOperator relationOperator = this.relationOperators.get(value);
        if (relationOperator == null) {
            throw new ParseException("The relational operator |" + value + "| is not a supported relational operator.");
        }
        return relationOperator;
    }

    private class PackageVersionRelationOperatorImpl
    implements PackageVersionRelationOperator {
        private String text;

        public PackageVersionRelationOperatorImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

