/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;

public class PackageVersionParserImpl
implements PackageVersionParser {
    private static final String REGEXP_UPSTREAM_VERSION = "([0-9]){1}([A-Za-z0-9.+:~])*";
    private static final String REGEXP_DEBIAN_REVISION = "([A-Za-z0-9.+~-])+";

    @Override
    public PackageVersion parsePackageVersion(String value, Context context) throws ParseException {
        String upstreamVersion;
        String epoch = null;
        String debianRevision = null;
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        String rest = value;
        int index = rest.indexOf(58);
        if (index != -1) {
            int intValue;
            epoch = rest.substring(0, index);
            rest = rest.substring(index + 1);
            if (epoch.startsWith("0") && !epoch.equals("0")) {
                throw new ParseException("Version |" + value + "| contains an invalid epoch |" + epoch + "|: An epoch can't start with 0 except it is 0.");
            }
            try {
                intValue = Integer.parseInt(epoch);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Version |" + value + "| contains an invalid epoch |" + epoch + "|: The epoch is not a valid integer.");
            }
            if (intValue < 0) {
                throw new ParseException("Version |" + value + "| contains an invalid epoch |" + epoch + "|: The epoch is negative.");
            }
        }
        if ((index = rest.indexOf(45)) == -1) {
            upstreamVersion = rest;
            rest = "";
        } else {
            upstreamVersion = rest.substring(0, index);
            rest = rest.substring(index + 1);
        }
        if (!upstreamVersion.matches(REGEXP_UPSTREAM_VERSION)) {
            throw new ParseException("Version |" + value + "| contains an invalid upstream version |" + upstreamVersion + "|");
        }
        if (!rest.isEmpty() && !(debianRevision = rest).matches(REGEXP_DEBIAN_REVISION)) {
            throw new ParseException("Version |" + value + "| contains an invalid Debian revision |" + debianRevision + "|");
        }
        PackageVersionImpl packageVersion = new PackageVersionImpl(epoch, upstreamVersion, debianRevision);
        return packageVersion;
    }

    private class PackageVersionImpl
    implements PackageVersion {
        private String epoch;
        private String upstreamVersion;
        private String debianRevision;

        public PackageVersionImpl(String epoch, String upstreamVersion, String debianRevision) {
            this.epoch = epoch;
            this.upstreamVersion = upstreamVersion;
            this.debianRevision = debianRevision;
        }

        @Override
        public String getEpoch() {
            return this.epoch;
        }

        @Override
        public String getUpstreamVersion() {
            return this.upstreamVersion;
        }

        @Override
        public String getDebianRevision() {
            return this.debianRevision;
        }

        @Override
        public String getText() {
            StringBuilder sb = new StringBuilder();
            if (this.epoch != null) {
                sb.append(this.epoch);
                sb.append(':');
            }
            sb.append(this.upstreamVersion);
            if (this.debianRevision != null) {
                sb.append('-');
                sb.append(this.debianRevision);
            }
            return sb.toString();
        }
    }
}

