/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackagePriority;
import net.sourceforge.javadpkg.control.PackagePriorityParser;
import net.sourceforge.javadpkg.control.impl.PackagePriorityUnsupportedWarning;

public class PackagePriorityParserImpl
implements PackagePriorityParser {
    private Map<String, PackagePriority> priorities = new TreeMap<String, PackagePriority>();

    public PackagePriorityParserImpl() {
        this.addPriority("required");
        this.addPriority("important");
        this.addPriority("standard");
        this.addPriority("optional");
        this.addPriority("extra");
    }

    private void addPriority(String text) {
        this.priorities.put(text, new PackagePriorityImpl(text));
    }

    @Override
    public PackagePriority parsePackagePriority(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        PackagePriority priority = this.priorities.get(value);
        if (priority == null) {
            context.addWarning(new PackagePriorityUnsupportedWarning(value));
            priority = new PackagePriorityImpl(value);
        }
        return priority;
    }

    private class PackagePriorityImpl
    implements PackagePriority {
        private String text;

        public PackagePriorityImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

