/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;

public class PackageNameParserImpl
implements PackageNameParser {
    @Override
    public PackageName parsePackageName(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (!value.matches("[a-z]{1}[a-z0-9+-.:]+")) {
            throw new ParseException("Package name |" + value + "| doesn't match the rules for package names.");
        }
        PackageNameImpl packageName = new PackageNameImpl(value);
        return packageName;
    }

    private class PackageNameImpl
    implements PackageName {
        private String name;

        public PackageNameImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

