/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMultiArchitecture;
import net.sourceforge.javadpkg.control.PackageMultiArchitectureParser;
import net.sourceforge.javadpkg.control.impl.PackageMultiArchitectureUnsupportedWarning;

public class PackageMultiArchitectureParserImpl
implements PackageMultiArchitectureParser {
    private Map<String, PackageMultiArchitecture> multiArchitectures = new TreeMap<String, PackageMultiArchitecture>();

    public PackageMultiArchitectureParserImpl() {
        this.addMultiArchitecture("same");
        this.addMultiArchitecture("foreign");
        this.addMultiArchitecture("allowed");
    }

    private void addMultiArchitecture(String multiArchitecture) {
        this.multiArchitectures.put(multiArchitecture, new PackageMultiArchitectureImpl(multiArchitecture));
    }

    @Override
    public PackageMultiArchitecture parsePackageMultiArchitecture(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        PackageMultiArchitecture multiArchitecture = this.multiArchitectures.get(value);
        if (multiArchitecture == null) {
            context.addWarning(new PackageMultiArchitectureUnsupportedWarning(value));
            multiArchitecture = new PackageMultiArchitectureImpl(value);
        }
        return multiArchitecture;
    }

    private class PackageMultiArchitectureImpl
    implements PackageMultiArchitecture {
        private String text;

        public PackageMultiArchitectureImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

