/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;

public class PackageMaintainerParserImpl
implements PackageMaintainerParser {
    @Override
    public PackageMaintainer parsePackageMaintainer(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        int indexStart = value.indexOf(60);
        if (indexStart == -1) {
            throw new ParseException("Can't parse maintainer |" + value + "|: Couldn't find bracket |<| for the start of the e-mail address.");
        }
        if (!value.endsWith(">")) {
            throw new ParseException("Can't parse maintainer |" + value + "|: Value doesn't end with bracket |>| for the end of the e-mail address.");
        }
        String name = value.substring(0, indexStart).trim();
        String address = value.substring(indexStart + 1, value.length() - 1);
        PackageMaintainerImpl maintainer = new PackageMaintainerImpl(name, address);
        return maintainer;
    }

    private class PackageMaintainerImpl
    implements PackageMaintainer {
        private String name;
        private String address;

        public PackageMaintainerImpl(String name, String address) {
            this.name = name;
            this.address = address;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAddress() {
            return this.address;
        }
    }
}

