/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperator;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorParser;

public class PackageDependencyParserImpl
implements PackageDependencyParser {
    private PackageNameParser packageNameParser;
    private PackageVersionRelationOperatorParser packageVersionRelationOperatorParser;
    private PackageVersionParser packageVersionParser;

    public PackageDependencyParserImpl(PackageNameParser packageNameParser, PackageVersionRelationOperatorParser packageVersionRelationOperatorParser, PackageVersionParser packageVersionParser) {
        if (packageNameParser == null) {
            throw new IllegalArgumentException("Argument packageNameParser is null.");
        }
        if (packageVersionRelationOperatorParser == null) {
            throw new IllegalArgumentException("Argument packageVersionRelationOperatorParser is null.");
        }
        if (packageVersionParser == null) {
            throw new IllegalArgumentException("Argument packageVersionParser is null.");
        }
        this.packageNameParser = packageNameParser;
        this.packageVersionRelationOperatorParser = packageVersionRelationOperatorParser;
        this.packageVersionParser = packageVersionParser;
    }

    @Override
    public PackageDependency parsePackageDependency(String value, Context context) throws ParseException {
        PackageDependency dependency;
        PackageVersionRelationOperator relationOperator = null;
        PackageVersion version = null;
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        String[] parts = value.split("\\|");
        if (parts.length > 1) {
            ArrayList<PackageDependency> dependencies = new ArrayList<PackageDependency>();
            for (String p : parts) {
                try {
                    dependency = this.parsePackageDependency(p.trim(), context);
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse dependencies |" + value + "|: " + e.getMessage(), e);
                }
                dependencies.add(dependency);
            }
            dependency = new PackageDependencyImpl(PackageDependency.Condition.OR, dependencies);
        } else {
            PackageName packageName;
            parts = value.split("[ \\t]+", 2);
            try {
                packageName = this.packageNameParser.parsePackageName(parts[0], context);
                if (parts.length > 1) {
                    String part = parts[1];
                    if (part.startsWith("(") && part.endsWith(")")) {
                        parts = (part = part.substring(1, part.length() - 1)).split(" ", 2);
                        if (parts.length == 1) {
                            parts = part.split("([0-9]){1}", 2);
                            if (parts.length == 1 || parts[0].length() == 0) {
                                parts = new String[]{part};
                            } else {
                                parts[1] = part.substring(parts[0].length());
                            }
                        }
                    } else {
                        throw new ParseException("Expected a version criteria, but found |" + part + "|.");
                    }
                    if (parts.length > 1) {
                        relationOperator = this.packageVersionRelationOperatorParser.parsePackageVersionRelationOperator(parts[0]);
                        version = this.packageVersionParser.parsePackageVersion(parts[1], context);
                    } else {
                        version = this.packageVersionParser.parsePackageVersion(parts[0], context);
                    }
                }
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse package dependency |" + value + "|: " + e.getMessage(), e);
            }
            dependency = new PackageDependencyImpl(packageName, relationOperator, version);
        }
        return dependency;
    }

    @Override
    public List<PackageDependency> parsePackageDependencies(String values, Context context) throws ParseException {
        String[] parts;
        if (values == null) {
            throw new IllegalArgumentException("Argument values is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        ArrayList<PackageDependency> dependencies = new ArrayList<PackageDependency>();
        for (String part : parts = values.split(",")) {
            PackageDependency dependency;
            try {
                dependency = this.parsePackageDependency(part.trim(), context);
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse dependencies |" + values + "|: " + e.getMessage(), e);
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private class PackageDependencyImpl
    implements PackageDependency {
        private PackageDependency.Condition condition;
        private List<PackageDependency> packageDependencies;
        private PackageName packageName;
        private PackageVersionRelationOperator relationOperator;
        private PackageVersion version;

        public PackageDependencyImpl(PackageDependency.Condition condition, List<PackageDependency> packageDependencies) {
            this.condition = condition;
            this.packageDependencies = new ArrayList<PackageDependency>(packageDependencies);
            this.packageName = null;
            this.relationOperator = null;
            this.version = null;
        }

        public PackageDependencyImpl(PackageName packageName, PackageVersionRelationOperator relationOperator, PackageVersion version) {
            this.condition = null;
            this.packageDependencies = new ArrayList<PackageDependency>();
            this.packageName = packageName;
            this.relationOperator = relationOperator;
            this.version = version;
        }

        @Override
        public boolean isCondition() {
            return this.condition != null;
        }

        @Override
        public PackageDependency.Condition getCondition() {
            return this.condition;
        }

        @Override
        public List<PackageDependency> getConditionPackageDependencies() {
            return new ArrayList<PackageDependency>(this.packageDependencies);
        }

        @Override
        public PackageName getPackage() {
            return this.packageName;
        }

        @Override
        public PackageVersionRelationOperator getRelationOperator() {
            return this.relationOperator;
        }

        @Override
        public PackageVersion getVersion() {
            return this.version;
        }
    }
}

