/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.List;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyBuilder;
import net.sourceforge.javadpkg.control.PackageNameBuilder;
import net.sourceforge.javadpkg.control.PackageVersionBuilder;
import net.sourceforge.javadpkg.control.PackageVersionRelationOperatorBuilder;

public class PackageDependencyBuilderImpl
implements PackageDependencyBuilder {
    private PackageNameBuilder packageNameBuilder;
    private PackageVersionRelationOperatorBuilder packageVersionRelationOperatorBuilder;
    private PackageVersionBuilder packageVersionBuilder;

    public PackageDependencyBuilderImpl(PackageNameBuilder packageNameBuilder, PackageVersionRelationOperatorBuilder packageVersionRelationOperatorBuilder, PackageVersionBuilder packageVersionBuilder) {
        if (packageNameBuilder == null) {
            throw new IllegalArgumentException("Argument packageNameBuilder is null.");
        }
        if (packageVersionRelationOperatorBuilder == null) {
            throw new IllegalArgumentException("Argument packageVersionRelationOperatorBuilder is null.");
        }
        if (packageVersionBuilder == null) {
            throw new IllegalArgumentException("Argument packageVersionBuilder is null.");
        }
        this.packageNameBuilder = packageNameBuilder;
        this.packageVersionRelationOperatorBuilder = packageVersionRelationOperatorBuilder;
        this.packageVersionBuilder = packageVersionBuilder;
    }

    @Override
    public String buildPackageDependency(PackageDependency dependency, Context context) throws BuildException {
        String value;
        if (dependency == null) {
            throw new IllegalArgumentException("Argument dependency is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (dependency.isCondition()) {
            StringBuilder sb = new StringBuilder();
            for (PackageDependency dep : dependency.getConditionPackageDependencies()) {
                if (sb.length() > 0) {
                    switch (dependency.getCondition()) {
                        case OR: {
                            sb.append(" | ");
                            break;
                        }
                        default: {
                            throw new BuildException("Unsupported dependency condition |" + (Object)((Object)dependency.getCondition()) + "|.");
                        }
                    }
                }
                value = this.buildPackageDependency(dep, context);
                sb.append(value);
            }
            value = sb.toString();
        } else {
            StringBuilder sb = new StringBuilder();
            try {
                value = this.packageNameBuilder.buildPackageName(dependency.getPackage(), context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build dependency: " + e.getMessage(), e);
            }
            sb.append(value);
            if (dependency.getVersion() != null) {
                sb.append(" (");
                if (dependency.getRelationOperator() != null) {
                    try {
                        value = this.packageVersionRelationOperatorBuilder.buildPackageVersionRelationOperator(dependency.getRelationOperator(), context);
                    }
                    catch (BuildException e) {
                        throw new BuildException("Couldn't build dependency: " + e.getMessage(), e);
                    }
                    sb.append(value);
                    sb.append(' ');
                }
                try {
                    value = this.packageVersionBuilder.buildPackageVersion(dependency.getVersion(), context);
                }
                catch (BuildException e) {
                    throw new BuildException("Couldn't build dependency: " + e.getMessage(), e);
                }
                sb.append(value);
                sb.append(')');
            }
            value = sb.toString();
        }
        return value;
    }

    @Override
    public String buildPackageDependencies(List<PackageDependency> dependencies, Context context) throws BuildException {
        if (dependencies == null) {
            throw new IllegalArgumentException("Argument dependencies is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        StringBuilder result = new StringBuilder();
        for (PackageDependency dependency : dependencies) {
            String value;
            if (result.length() > 0) {
                result.append(", ");
            }
            try {
                value = this.buildPackageDependency(dependency, context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build dependencies: " + e.getMessage(), e);
            }
            result.append(value);
        }
        return result.toString();
    }
}

