/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Homepage;
import net.sourceforge.javadpkg.control.HomepageParser;

public class HomepageParserImpl
implements HomepageParser {
    @Override
    public Homepage parseHomepage(String value, Context context) throws ParseException {
        URL url;
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ParseException("Couldn't parser homepage |" + value + "|: " + e.getMessage(), e);
        }
        HomepageImpl homepage = new HomepageImpl(url);
        return homepage;
    }

    private class HomepageImpl
    implements Homepage {
        private URL url;

        public HomepageImpl(URL url) {
            this.url = url;
        }

        @Override
        public URL getURL() {
            return this.url;
        }
    }
}

