/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionParser;

public class DescriptionParserImpl
implements DescriptionParser {
    @Override
    public Description parseDescription(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        String[] lines = value.split("\\n");
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (result.length() > 0) {
                result.append('\n');
            }
            if (".".equals(line)) continue;
            result.append(line);
        }
        DescriptionImpl description = new DescriptionImpl(result.toString());
        return description;
    }

    private class DescriptionImpl
    implements Description {
        private String text;

        public DescriptionImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

