/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.io.IOException;
import java.util.Map;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.ArchitectureParser;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.ControlConstants;
import net.sourceforge.javadpkg.control.ControlParser;
import net.sourceforge.javadpkg.control.DescriptionParser;
import net.sourceforge.javadpkg.control.EssentialParser;
import net.sourceforge.javadpkg.control.HomepageParser;
import net.sourceforge.javadpkg.control.ModuleAliasesParser;
import net.sourceforge.javadpkg.control.PackageDependencyParser;
import net.sourceforge.javadpkg.control.PackageMaintainerParser;
import net.sourceforge.javadpkg.control.PackageMultiArchitectureParser;
import net.sourceforge.javadpkg.control.PackageNameParser;
import net.sourceforge.javadpkg.control.PackagePriorityParser;
import net.sourceforge.javadpkg.control.PackageVersionParser;
import net.sourceforge.javadpkg.control.SectionParser;
import net.sourceforge.javadpkg.control.SizeParser;
import net.sourceforge.javadpkg.control.impl.ArchitectureParserImpl;
import net.sourceforge.javadpkg.control.impl.BinaryControlImpl;
import net.sourceforge.javadpkg.control.impl.ControlRecommendedFieldMissingWarning;
import net.sourceforge.javadpkg.control.impl.ControlUnsupportedFieldFoundWarning;
import net.sourceforge.javadpkg.control.impl.DescriptionParserImpl;
import net.sourceforge.javadpkg.control.impl.EssentialParserImpl;
import net.sourceforge.javadpkg.control.impl.HomepageParserImpl;
import net.sourceforge.javadpkg.control.impl.ModuleAliasesParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageDependencyParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageMultiArchitectureParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameParserImpl;
import net.sourceforge.javadpkg.control.impl.PackagePriorityParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorParserImpl;
import net.sourceforge.javadpkg.control.impl.SectionParserImpl;
import net.sourceforge.javadpkg.control.impl.SizeParserImpl;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldParser;
import net.sourceforge.javadpkg.field.FieldType;
import net.sourceforge.javadpkg.field.impl.FieldParserImpl;
import net.sourceforge.javadpkg.io.DataSource;

public class ControlParserImpl
implements ControlParser,
ControlConstants {
    private FieldParser fieldParser = new FieldParserImpl(false, false, false);
    private PackageNameParser packageNameParser = new PackageNameParserImpl();
    private PackageVersionParser packageVersionParser = new PackageVersionParserImpl();
    private SectionParser sectionParser = new SectionParserImpl();
    private PackagePriorityParser packagePriorityParser = new PackagePriorityParserImpl();
    private ArchitectureParser architectureParser = new ArchitectureParserImpl();
    private PackageMultiArchitectureParser packageMultiArchitectureParser = new PackageMultiArchitectureParserImpl();
    private EssentialParser essentialParser = new EssentialParserImpl();
    private PackageDependencyParser packageDependencyParser = new PackageDependencyParserImpl(this.packageNameParser, new PackageVersionRelationOperatorParserImpl(), this.packageVersionParser);
    private SizeParser sizeParser = new SizeParserImpl();
    private PackageMaintainerParser packageMaintainerParser = new PackageMaintainerParserImpl();
    private ModuleAliasesParser moduleAliasesParser = new ModuleAliasesParserImpl();
    private DescriptionParser descriptionParser = new DescriptionParserImpl();
    private HomepageParser homepageParser = new HomepageParserImpl();

    @Override
    public Control parseControl(DataSource source, Context context) throws IOException, ParseException {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        BinaryControlImpl control = new BinaryControlImpl();
        Map<String, Field> fields = this.fieldParser.parseFieldsAsMap(source, context);
        this.processFields(source, context, control, fields);
        return control;
    }

    private void processFields(DataSource source, Context context, BinaryControlImpl control, Map<String, Field> fields) throws ParseException {
        try {
            Field field = this.getField(context, fields, "Package", FieldType.MANDATORY);
            try {
                control.setPackage(this.packageNameParser.parsePackageName(field.getValue(), context));
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
            }
            field = this.getField(context, fields, "Source", FieldType.OPTIONAL);
            if (field != null) {
                try {
                    control.setSource(this.packageDependencyParser.parsePackageDependency(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            field = this.getField(context, fields, "Version", FieldType.MANDATORY);
            try {
                control.setVersion(this.packageVersionParser.parsePackageVersion(field.getValue(), context));
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
            }
            field = this.getField(context, fields, "Section", FieldType.RECOMMENDED);
            if (field != null) {
                try {
                    control.setSection(this.sectionParser.parseSection(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Priority", FieldType.RECOMMENDED)) != null) {
                try {
                    control.setPriority(this.packagePriorityParser.parsePackagePriority(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            field = this.getField(context, fields, "Architecture", FieldType.MANDATORY);
            try {
                control.setArchitecture(this.architectureParser.parseArchitecture(field.getValue(), context));
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
            }
            if ("source.".equals(control.getArchitecture().getText())) {
                throw new ParseException("Found package having the architecture |source|, but that kind of package is currently not supported.");
            }
            field = this.getField(context, fields, "Multi-Arch", FieldType.OPTIONAL);
            if (field != null) {
                try {
                    control.setMultiArchitecture(this.packageMultiArchitectureParser.parsePackageMultiArchitecture(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Essential", FieldType.OPTIONAL)) != null) {
                try {
                    control.setEssential(this.essentialParser.parseEssential(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Depends", FieldType.OPTIONAL)) != null) {
                try {
                    control.setDepends(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Recommends", FieldType.OPTIONAL)) != null) {
                try {
                    control.setRecommends(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Suggests", FieldType.OPTIONAL)) != null) {
                try {
                    control.setSuggests(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Enhance", FieldType.OPTIONAL)) != null) {
                try {
                    control.setEnhances(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Pre-Depends", FieldType.OPTIONAL)) != null) {
                try {
                    control.setPreDepends(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "breaks", FieldType.OPTIONAL)) != null) {
                try {
                    control.setBreaks(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Conflicts", FieldType.OPTIONAL)) != null) {
                try {
                    control.setConflicts(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Provides", FieldType.OPTIONAL)) != null) {
                try {
                    control.setProvides(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Replaces", FieldType.OPTIONAL)) != null) {
                try {
                    control.setReplaces(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Built-Using", FieldType.OPTIONAL)) != null) {
                try {
                    control.setBuiltUsing(this.packageDependencyParser.parsePackageDependencies(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Installed-Size", FieldType.OPTIONAL)) != null) {
                try {
                    control.setInstalledSize(this.sizeParser.parseSizeInKiloBytes(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            field = this.getField(context, fields, "Maintainer", FieldType.RECOMMENDED);
            try {
                control.setMaintainer(this.packageMaintainerParser.parsePackageMaintainer(field.getValue(), context));
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
            }
            field = this.getField(context, fields, "Original-Maintainer", FieldType.OPTIONAL);
            if (field != null) {
                try {
                    control.setOriginalMaintainer(this.packageMaintainerParser.parsePackageMaintainer(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if ((field = this.getField(context, fields, "Modaliases", FieldType.OPTIONAL)) != null) {
                try {
                    control.setModuleAliases(this.moduleAliasesParser.parseModuleAliases(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            field = this.getField(context, fields, "Description", FieldType.MANDATORY);
            try {
                control.setDescription(this.descriptionParser.parseDescription(field.getValue(), context));
            }
            catch (ParseException e) {
                throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
            }
            field = this.getField(context, fields, "Homepage", FieldType.OPTIONAL);
            if (field != null) {
                try {
                    control.setHomepage(this.homepageParser.parseHomepage(field.getValue(), context));
                }
                catch (ParseException e) {
                    throw new ParseException("Couldn't parse field |" + field.getName() + "|: " + e.getMessage(), e);
                }
            }
            if (!fields.isEmpty()) {
                for (Field f : fields.values()) {
                    context.addWarning(new ControlUnsupportedFieldFoundWarning(f.getName(), f.getValue()));
                }
            }
        }
        catch (ParseException e) {
            throw new ParseException("Couldn't parse fields in source |" + source.getName() + "|: " + e.getMessage(), e);
        }
    }

    private Field getField(Context context, Map<String, Field> fields, String name, FieldType type) throws ParseException {
        Field field = fields.remove(name.toLowerCase());
        if (field == null) {
            switch (type) {
                case MANDATORY: {
                    throw new ParseException("Mandatory field |" + name + "| not found.");
                }
                case RECOMMENDED: {
                    context.addWarning(new ControlRecommendedFieldMissingWarning(name));
                    break;
                }
                case OPTIONAL: {
                    break;
                }
                default: {
                    throw new ParseException("Unsupported field type |" + (Object)((Object)type) + "|.");
                }
            }
        }
        return field;
    }
}

