/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.ArchitectureBuilder;
import net.sourceforge.javadpkg.control.BinaryControl;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.ControlBuilder;
import net.sourceforge.javadpkg.control.ControlConstants;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.control.DescriptionBuilder;
import net.sourceforge.javadpkg.control.EssentialBuilder;
import net.sourceforge.javadpkg.control.Homepage;
import net.sourceforge.javadpkg.control.HomepageBuilder;
import net.sourceforge.javadpkg.control.ModuleAliasesBuilder;
import net.sourceforge.javadpkg.control.PackageDependency;
import net.sourceforge.javadpkg.control.PackageDependencyBuilder;
import net.sourceforge.javadpkg.control.PackageMaintainer;
import net.sourceforge.javadpkg.control.PackageMaintainerBuilder;
import net.sourceforge.javadpkg.control.PackageMultiArchitecture;
import net.sourceforge.javadpkg.control.PackageMultiArchitectureBuilder;
import net.sourceforge.javadpkg.control.PackageName;
import net.sourceforge.javadpkg.control.PackageNameBuilder;
import net.sourceforge.javadpkg.control.PackagePriority;
import net.sourceforge.javadpkg.control.PackagePriorityBuilder;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.PackageVersionBuilder;
import net.sourceforge.javadpkg.control.Section;
import net.sourceforge.javadpkg.control.SectionBuilder;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.control.SizeBuilder;
import net.sourceforge.javadpkg.control.impl.ArchitectureBuilderImpl;
import net.sourceforge.javadpkg.control.impl.ControlRecommendedFieldNotSetWarning;
import net.sourceforge.javadpkg.control.impl.DescriptionBuilderImpl;
import net.sourceforge.javadpkg.control.impl.EssentialBuilderImpl;
import net.sourceforge.javadpkg.control.impl.HomepageBuilderImpl;
import net.sourceforge.javadpkg.control.impl.ModuleAliasesBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageDependencyBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageMaintainerBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageMultiArchitectureBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageNameBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackagePriorityBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionBuilderImpl;
import net.sourceforge.javadpkg.control.impl.PackageVersionRelationOperatorBuilderImpl;
import net.sourceforge.javadpkg.control.impl.SectionBuilderImpl;
import net.sourceforge.javadpkg.control.impl.SizeBuilderImpl;
import net.sourceforge.javadpkg.field.Field;
import net.sourceforge.javadpkg.field.FieldBuilder;
import net.sourceforge.javadpkg.field.FieldType;
import net.sourceforge.javadpkg.field.impl.FieldBuilderImpl;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.io.DataTarget;

public class ControlBuilderImpl
implements ControlBuilder,
ControlConstants {
    private PackageNameBuilder packageNameBuilder = new PackageNameBuilderImpl();
    private PackageDependencyBuilder packageDependencyBuilder;
    private PackageVersionBuilder packageVersionBuilder = new PackageVersionBuilderImpl();
    private ArchitectureBuilder architectureBuilder;
    private SectionBuilder sectionBuilder;
    private PackagePriorityBuilder packagePriorityBuilder;
    private EssentialBuilder essentialBuilder;
    private SizeBuilder sizeBuilder;
    private PackageMaintainerBuilder packageMaintainerBuilder;
    private DescriptionBuilder descriptionBuilder;
    private HomepageBuilder homepageBuilder;
    private PackageMultiArchitectureBuilder packageMultiArchitectureBuilder;
    private ModuleAliasesBuilder moduleAliasesBuilder;
    private FieldBuilder fieldBuilder;

    public ControlBuilderImpl() {
        this.packageDependencyBuilder = new PackageDependencyBuilderImpl(this.packageNameBuilder, new PackageVersionRelationOperatorBuilderImpl(), this.packageVersionBuilder);
        this.architectureBuilder = new ArchitectureBuilderImpl();
        this.sectionBuilder = new SectionBuilderImpl();
        this.packagePriorityBuilder = new PackagePriorityBuilderImpl();
        this.essentialBuilder = new EssentialBuilderImpl();
        this.sizeBuilder = new SizeBuilderImpl();
        this.packageMaintainerBuilder = new PackageMaintainerBuilderImpl();
        this.descriptionBuilder = new DescriptionBuilderImpl();
        this.homepageBuilder = new HomepageBuilderImpl();
        this.packageMultiArchitectureBuilder = new PackageMultiArchitectureBuilderImpl();
        this.moduleAliasesBuilder = new ModuleAliasesBuilderImpl();
        this.fieldBuilder = new FieldBuilderImpl();
    }

    @Override
    public void buildControl(Control control, DataTarget target, Context context) throws IOException, BuildException {
        Size installedSize;
        if (control == null) {
            throw new IllegalArgumentException("Argument control is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (control instanceof BinaryControl) {
            installedSize = ((BinaryControl)control).getInstalledSize();
            if (installedSize == null) {
                throw new IllegalArgumentException("Property installedSize of argument control is null.");
            }
        } else {
            throw new BuildException("Can't build control of type |" + control.getClass().getCanonicalName() + "| as currently only control of type |" + BinaryControl.class.getCanonicalName() + "| is supported.");
        }
        this.buildControl(control, installedSize, target, context);
    }

    @Override
    public void buildControl(Control control, Size installedSize, DataTarget target, Context context) throws IOException, BuildException {
        if (control == null) {
            throw new IllegalArgumentException("Argument control is null.");
        }
        if (installedSize == null) {
            throw new IllegalArgumentException("Argument installedSize is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (installedSize.getBytes() < 0L) {
            throw new IllegalArgumentException("Argument installedSize is negative: " + installedSize.getBytes());
        }
        if (!(control instanceof BinaryControl)) {
            throw new BuildException("Can't build control of type |" + control.getClass().getCanonicalName() + "| as currently only control of type |" + BinaryControl.class.getCanonicalName() + "| is supported.");
        }
        List<Field> fields = this.buildBinaryControl((BinaryControl)control, installedSize, context);
        try {
            this.fieldBuilder.buildFields(fields, target, context);
        }
        catch (BuildException e) {
            throw new BuildException("Couldn't write control file: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IOException("Couldn't write control file: " + e.getMessage(), e);
        }
    }

    private List<Field> buildBinaryControl(BinaryControl control, Size installedSize, Context context) throws BuildException {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addField(context, control, fields, "Package", control.getPackage(), FieldType.MANDATORY, new FieldValueBuilder<PackageName, PackageNameBuilder>(this.packageNameBuilder){

            @Override
            public String build(PackageNameBuilder builder, PackageName value, Context context) throws BuildException {
                return builder.buildPackageName(value, context);
            }
        });
        this.addField(context, control, fields, "Source", control.getSource(), FieldType.OPTIONAL, new FieldValueBuilder<PackageDependency, PackageDependencyBuilder>(this.packageDependencyBuilder){

            @Override
            public String build(PackageDependencyBuilder builder, PackageDependency value, Context context) throws BuildException {
                return builder.buildPackageDependency(value, context);
            }
        });
        this.addField(context, control, fields, "Version", control.getVersion(), FieldType.MANDATORY, new FieldValueBuilder<PackageVersion, PackageVersionBuilder>(this.packageVersionBuilder){

            @Override
            public String build(PackageVersionBuilder builder, PackageVersion value, Context context) throws BuildException {
                return builder.buildPackageVersion(value, context);
            }
        });
        this.addField(context, control, fields, "Architecture", control.getArchitecture(), FieldType.MANDATORY, new FieldValueBuilder<Architecture, ArchitectureBuilder>(this.architectureBuilder){

            @Override
            public String build(ArchitectureBuilder builder, Architecture value, Context context) throws BuildException {
                return builder.buildArchitecture(value, context);
            }
        });
        this.addField(context, control, fields, "Section", control.getSection(), FieldType.RECOMMENDED, new FieldValueBuilder<Section, SectionBuilder>(this.sectionBuilder){

            @Override
            public String build(SectionBuilder builder, Section value, Context context) throws BuildException {
                return builder.buildSection(value, context);
            }
        });
        this.addField(context, control, fields, "Priority", control.getPriority(), FieldType.RECOMMENDED, new FieldValueBuilder<PackagePriority, PackagePriorityBuilder>(this.packagePriorityBuilder){

            @Override
            public String build(PackagePriorityBuilder builder, PackagePriority value, Context context) throws BuildException {
                return builder.buildPackagePriority(value, context);
            }
        });
        this.addField(context, control, fields, "Essential", control.getEssential(), FieldType.OPTIONAL, new FieldValueBuilder<Boolean, EssentialBuilder>(this.essentialBuilder){

            @Override
            public String build(EssentialBuilder builder, Boolean value, Context context) throws BuildException {
                return builder.buildEssential(value, context);
            }
        });
        List<PackageDependency> dependencies = control.getDepends();
        this.addDependenciesField(context, control, fields, "Depends", dependencies, FieldType.OPTIONAL);
        dependencies = control.getRecommends();
        this.addDependenciesField(context, control, fields, "Recommends", dependencies, FieldType.OPTIONAL);
        dependencies = control.getSuggests();
        this.addDependenciesField(context, control, fields, "Suggests", dependencies, FieldType.OPTIONAL);
        dependencies = control.getEnhances();
        this.addDependenciesField(context, control, fields, "Enhance", dependencies, FieldType.OPTIONAL);
        dependencies = control.getPreDepends();
        this.addDependenciesField(context, control, fields, "Pre-Depends", dependencies, FieldType.OPTIONAL);
        dependencies = control.getBreaks();
        this.addDependenciesField(context, control, fields, "breaks", dependencies, FieldType.OPTIONAL);
        dependencies = control.getConflicts();
        this.addDependenciesField(context, control, fields, "Conflicts", dependencies, FieldType.OPTIONAL);
        this.addField(context, control, fields, "Installed-Size", installedSize, FieldType.OPTIONAL, new FieldValueBuilder<Size, SizeBuilder>(this.sizeBuilder){

            @Override
            public String build(SizeBuilder builder, Size value, Context context) throws BuildException {
                return builder.buildSizeInKiloBytes(value, context);
            }
        });
        this.addMaintainerField(context, control, fields, "Maintainer", control.getMaintainer(), FieldType.MANDATORY);
        this.addField(context, control, fields, "Homepage", control.getHomepage(), FieldType.OPTIONAL, new FieldValueBuilder<Homepage, HomepageBuilder>(this.homepageBuilder){

            @Override
            public String build(HomepageBuilder builder, Homepage value, Context context) throws BuildException {
                return builder.buildHomepage(value, context);
            }
        });
        this.addDependenciesField(context, control, fields, "Built-Using", control.getBuiltUsing(), FieldType.OPTIONAL);
        this.addField(context, control, fields, "Multi-Arch", control.getMultiArchitecture(), FieldType.OPTIONAL, new FieldValueBuilder<PackageMultiArchitecture, PackageMultiArchitectureBuilder>(this.packageMultiArchitectureBuilder){

            @Override
            public String build(PackageMultiArchitectureBuilder builder, PackageMultiArchitecture value, Context context) throws BuildException {
                return builder.buildPackageMultiArchitecture(value, context);
            }
        });
        this.addMaintainerField(context, control, fields, "Original-Maintainer", control.getOriginalMaintainer(), FieldType.OPTIONAL);
        this.addDependenciesField(context, control, fields, "Provides", control.getProvides(), FieldType.OPTIONAL);
        this.addField(context, control, fields, "Modaliases", control.getModuleAliases(), FieldType.OPTIONAL, new FieldValueBuilder<String, ModuleAliasesBuilder>(this.moduleAliasesBuilder){

            @Override
            public String build(ModuleAliasesBuilder builder, String value, Context context) throws BuildException {
                return builder.buildModuleAliases(value, context);
            }
        });
        this.addField(context, control, fields, "Description", control.getDescription(), FieldType.MANDATORY, new FieldValueBuilder<Description, DescriptionBuilder>(this.descriptionBuilder){

            @Override
            public String build(DescriptionBuilder builder, Description value, Context context) throws BuildException {
                return builder.buildDescription(value, context);
            }
        });
        return fields;
    }

    private void assertField(Context context, String name, Object value, FieldType type) throws BuildException {
        if (value == null) {
            switch (type) {
                case MANDATORY: {
                    throw new BuildException("Mandatory field |" + name + "| is not set.");
                }
                case RECOMMENDED: {
                    context.addWarning(new ControlRecommendedFieldNotSetWarning(name));
                    break;
                }
                case OPTIONAL: {
                    break;
                }
                default: {
                    throw new BuildException("Unsupported field type |" + (Object)((Object)type) + "|.");
                }
            }
        }
    }

    private <T, B> void addField(Context context, BinaryControl control, List<Field> fields, String name, T value, FieldType type, FieldValueBuilder<T, B> builder) throws BuildException {
        this.assertField(context, name, value, type);
        if (value != null) {
            String fieldValue;
            try {
                fieldValue = builder.build(value, context);
            }
            catch (BuildException e) {
                throw new BuildException("Couldn't build field |" + name + "|: ", e);
            }
            if (!fieldValue.isEmpty()) {
                fields.add(new FieldImpl(name, fieldValue));
            }
        }
    }

    private void addDependenciesField(Context context, BinaryControl control, List<Field> fields, String name, List<PackageDependency> dependencies, FieldType type) throws BuildException {
        this.addField(context, control, fields, name, dependencies, type, new FieldValueBuilder<List<PackageDependency>, PackageDependencyBuilder>(this.packageDependencyBuilder){

            @Override
            public String build(PackageDependencyBuilder builder, List<PackageDependency> value, Context context) throws BuildException {
                return builder.buildPackageDependencies(value, context);
            }
        });
    }

    private void addMaintainerField(Context context, BinaryControl control, List<Field> fields, String name, PackageMaintainer maintainer, FieldType type) throws BuildException {
        this.addField(context, control, fields, name, maintainer, type, new FieldValueBuilder<PackageMaintainer, PackageMaintainerBuilder>(this.packageMaintainerBuilder){

            @Override
            public String build(PackageMaintainerBuilder builder, PackageMaintainer value, Context context) throws BuildException {
                return builder.buildPackageMaintainer(value, context);
            }
        });
    }

    private abstract class FieldValueBuilder<V, B> {
        private B builder;

        public FieldValueBuilder(B builder) {
            this.builder = builder;
        }

        public String build(V value, Context context) throws BuildException {
            return this.build(this.builder, value, context);
        }

        public abstract String build(B var1, V var2, Context var3) throws BuildException;
    }
}

