/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.Architecture;
import net.sourceforge.javadpkg.control.ArchitectureParser;
import net.sourceforge.javadpkg.control.impl.ArchitectureUnsupportedWarning;

public class ArchitectureParserImpl
implements ArchitectureParser {
    private Map<String, Architecture> architectures = new TreeMap<String, Architecture>();

    public ArchitectureParserImpl() {
        this.addArchitecture("all");
        this.addArchitecture("source");
        this.addArchitecture("amd64");
        this.addArchitecture("i386");
    }

    private void addArchitecture(String architecture) {
        this.architectures.put(architecture, new ArchitectureImpl(architecture));
    }

    @Override
    public Architecture parseArchitecture(String value, Context context) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        Architecture architecture = this.architectures.get(value);
        if (architecture == null) {
            context.addWarning(new ArchitectureUnsupportedWarning(value));
            architecture = new ArchitectureImpl(value);
        }
        return architecture;
    }

    private class ArchitectureImpl
    implements Architecture {
        private String text;

        public ArchitectureImpl(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

