/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.Template;
import net.sourceforge.javadpkg.Templates;
import net.sourceforge.javadpkg.control.Description;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.impl.TemplatesParserImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class TemplatesParserImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        Templates templates;
        TemplatesParserImpl parser = new TemplatesParserImpl();
        DataSource source = TemplatesParserImplTest.createSource(Arrays.asList("Template: hostname", "Type: string", "Default: debian", "Description: unqualified hostname for this computer", " This is the name by which this computer will be known on the network. It", " has to be a unique name in your domain.", "", "Template: domain", "Type: string", "Description: domain for this computer", " This is the domain your computer is a member of. Typically it is", " something like \"mycompany.com\" or \"myuniversity.edu\"."), "templates");
        ContextImpl context = new ContextImpl();
        try {
            parser.parseTemplates((DataSource)null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parseTemplates(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            templates = parser.parseTemplates(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)templates);
        List templateList = templates.getTemplates();
        Assert.assertNotNull((Object)templateList);
        Assert.assertEquals((long)2L, (long)templateList.size());
        Template template = (Template)templateList.get(0);
        Assert.assertEquals((Object)"hostname", (Object)template.getName());
        Assert.assertNotNull((Object)template.getType());
        Assert.assertEquals((Object)"string", (Object)template.getType().getText());
        Map defaultValue = template.getDefaultValue();
        Assert.assertNotNull((Object)defaultValue);
        Assert.assertEquals((long)1L, (long)defaultValue.size());
        Assert.assertEquals((Object)"debian", defaultValue.get(""));
        Map choices = template.getChoices();
        Assert.assertNull((Object)choices);
        Map descriptions = template.getDescriptions();
        Assert.assertNotNull((Object)descriptions);
        Assert.assertEquals((long)1L, (long)descriptions.size());
        Description description = (Description)descriptions.get("");
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"unqualified hostname for this computer\nThis is the name by which this computer will be known on the network. It\nhas to be a unique name in your domain.", (Object)description.getText());
        template = (Template)templateList.get(1);
        Assert.assertEquals((Object)"domain", (Object)template.getName());
        Assert.assertNotNull((Object)template.getType());
        Assert.assertEquals((Object)"string", (Object)template.getType().getText());
        defaultValue = template.getDefaultValue();
        Assert.assertNotNull((Object)defaultValue);
        Assert.assertEquals((long)0L, (long)defaultValue.size());
        choices = template.getChoices();
        Assert.assertNull((Object)choices);
        descriptions = template.getDescriptions();
        Assert.assertNotNull((Object)descriptions);
        Assert.assertEquals((long)1L, (long)descriptions.size());
        description = (Description)descriptions.get("");
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"domain for this computer\nThis is the domain your computer is a member of. Typically it is\nsomething like \"mycompany.com\" or \"myuniversity.edu\".", (Object)description.getText());
    }
}

