/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.Copyright;
import net.sourceforge.javadpkg.DebianPackageBuilder;
import net.sourceforge.javadpkg.Script;
import net.sourceforge.javadpkg.control.Control;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;

public class DebianPackageBuilderMock
implements DebianPackageBuilder {
    private Control control = null;
    private Size installedSizeOverhead = null;
    private Script preInstall = null;
    private Script postInstall = null;
    private Script preRemove = null;
    private Script postRemove = null;
    private Map<String, DataNode> dataMap = new HashMap<String, DataNode>();
    private Copyright copyright = null;
    private ChangeLog changeLog = null;

    public void setControl(Control control) {
        this.control = control;
    }

    public Control getControl() {
        return this.control;
    }

    public void setInstalledSizeOverhead(Size installedSizeOverhead) {
        this.installedSizeOverhead = installedSizeOverhead;
    }

    public Size getInstalledSizeOverhead() {
        return this.installedSizeOverhead;
    }

    public void setPreInstall(Script preInstall) {
        this.preInstall = preInstall;
    }

    public Script getPreInstall() {
        return this.preInstall;
    }

    public void setPostInstall(Script postInstall) {
        this.postInstall = postInstall;
    }

    public Script getPostInstall() {
        return this.postInstall;
    }

    public void setPreRemove(Script preRemove) {
        this.preRemove = preRemove;
    }

    public Script getPreRemove() {
        return this.preRemove;
    }

    public void setPostRemove(Script postRemove) {
        this.postRemove = postRemove;
    }

    public Script getPostRemove() {
        return this.postRemove;
    }

    public void addDataDirectory(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        DataNode data = new DataNode(path, null, null);
        if (this.dataMap.put(path, data) != null) {
            throw new IllegalArgumentException("Data with path |" + path + "| already exists.");
        }
    }

    public void addDataDirectory(String path, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        DataNode data = new DataNode(path, owner, mode);
        if (this.dataMap.put(path, data) != null) {
            throw new IllegalArgumentException("Data with path |" + path + "| already exists.");
        }
    }

    public void addDataFile(DataSource source, String path) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        DataNode data = new DataNode(source, path, null, null);
        if (this.dataMap.put(path, data) != null) {
            throw new IllegalArgumentException("Data with path |" + path + "| already exists.");
        }
    }

    public void addDataFile(DataSource source, String path, FileOwner owner, FileMode mode) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        DataNode data = new DataNode(source, path, owner, mode);
        if (this.dataMap.put(path, data) != null) {
            throw new IllegalArgumentException("Data with path |" + path + "| already exists.");
        }
    }

    public void addDataSymLink(String path, String target, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        DataNode data = new DataNode(path, target, owner, mode);
        if (this.dataMap.put(path, data) != null) {
            throw new IllegalArgumentException("Data with path |" + path + "| already exists.");
        }
    }

    public List<DataNode> getDataNodes() {
        ArrayList<DataNode> result = new ArrayList<DataNode>(this.dataMap.values());
        Collections.sort(result);
        return result;
    }

    public String getDataNodesAsString() {
        StringBuilder sb = new StringBuilder();
        List<DataNode> nodes = this.getDataNodes();
        for (DataNode node : nodes) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            FileOwner owner = node.getOwner();
            Long groupId = owner.getGroupId();
            Long userId = owner.getUserId();
            Long size = null;
            String source = null;
            String target = null;
            if (node.isDirectory()) {
                sb.append('d');
            } else {
                if (!node.isSymLink()) {
                    size = node.getSource().getLength();
                    source = node.getSource().getName();
                }
                if (node.isSymLink()) {
                    target = node.getTarget();
                    sb.append('l');
                } else {
                    sb.append('-');
                }
            }
            sb.append(node.getMode().getText());
            sb.append(String.format(" %5d %-8s %5d %-8s %10d %-40s", groupId, owner.getGroupName(), userId, owner.getUserName(), size, node.getPath()));
            if (source != null) {
                sb.append(String.format(" (Source: |%s|)", source));
                continue;
            }
            if (target == null) continue;
            sb.append(String.format(" (Target: |%s|)", target));
        }
        return sb.toString();
    }

    public void setCopyright(Copyright copyright) {
        this.copyright = copyright;
    }

    public Copyright getCopyright() {
        return this.copyright;
    }

    public void setChangeLog(ChangeLog changeLog) {
        this.changeLog = changeLog;
    }

    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    public void buildDebianPackage(DataTarget target, Context context) throws IOException, BuildException {
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
    }

    public class DataNode
    implements Comparable<DataNode> {
        private DataSource source;
        private String path;
        private String target;
        private FileOwner owner;
        private FileMode mode;

        private DataNode(String path, FileOwner owner, FileMode mode) {
            this.source = null;
            this.path = path;
            this.target = null;
            this.owner = owner;
            this.mode = mode;
        }

        private DataNode(DataSource source, String path, FileOwner owner, FileMode mode) {
            this.source = source;
            this.path = path;
            this.target = null;
            this.owner = owner;
            this.mode = mode;
        }

        private DataNode(String path, String target, FileOwner owner, FileMode mode) {
            this.source = null;
            this.path = path;
            this.target = target;
            this.owner = owner;
            this.mode = mode;
        }

        public DataSource getSource() {
            return this.source;
        }

        public String getPath() {
            return this.path;
        }

        public String getTarget() {
            return this.target;
        }

        public FileOwner getOwner() {
            return this.owner;
        }

        public FileMode getMode() {
            return this.mode;
        }

        public boolean isDirectory() {
            return this.source == null && this.target == null;
        }

        public boolean isFile() {
            return this.source != null || this.target != null;
        }

        public boolean isSymLink() {
            return this.target != null;
        }

        @Override
        public int compareTo(DataNode o) {
            return this.path.compareTo(o.path);
        }
    }
}

