/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.impl.ChangeLogParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class ChangeLogParserImplTest
extends AbstractDpkgTest {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);

    @Test
    public void testParseChangeLog() {
        ChangeLog changeLog;
        ChangeLogParserImpl parser = new ChangeLogParserImpl();
        DataSource source = ChangeLogParserImplTest.createSource(Arrays.asList(""), "copyright");
        ContextImpl context = new ContextImpl();
        try {
            parser.parseChangeLog(null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            parser.parseChangeLog(source, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        source = ChangeLogParserImplTest.createSource(Arrays.asList("mypackage (1.0.0) lucid precise trusty; urgency=low", "", "  * change details", "    more change details", "    .", "    more change details after an empty line", "", "  * even more change details", "", " -- John Doe <j.doe@example.com>  Wed, 04 May 2016 15:05:00 +0200"), "copyright");
        try {
            changeLog = parser.parseChangeLog(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)changeLog);
        List entries = changeLog.getEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)1L, (long)entries.size());
        ChangeLogVersionEntry entry = (ChangeLogVersionEntry)entries.get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertNotNull((Object)entry.getPackage());
        Assert.assertEquals((Object)"mypackage", (Object)entry.getPackage().getName());
        Assert.assertNotNull((Object)entry.getVersion());
        Assert.assertEquals((Object)"1.0.0", (Object)entry.getVersion().getText());
        List distributions = entry.getDistributions();
        Assert.assertNotNull((Object)distributions);
        Assert.assertEquals((long)3L, (long)distributions.size());
        Assert.assertEquals((Object)"lucid", distributions.get(0));
        Assert.assertEquals((Object)"precise", distributions.get(1));
        Assert.assertEquals((Object)"trusty", distributions.get(2));
        Assert.assertNotNull((Object)entry.getUrgency());
        Assert.assertEquals((Object)"low", (Object)entry.getUrgency().getText());
        List details = entry.getDetails();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((long)2L, (long)details.size());
        ChangeLogVersionEntryDetail detail = (ChangeLogVersionEntryDetail)details.get(0);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"change details\nmore change details\n\nmore change details after an empty line", (Object)detail.getText());
        detail = (ChangeLogVersionEntryDetail)details.get(1);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"even more change details", (Object)detail.getText());
        Assert.assertNotNull((Object)entry.getMaintainer());
        Assert.assertEquals((Object)"John Doe", (Object)entry.getMaintainer().getName());
        Assert.assertEquals((Object)"j.doe@example.com", (Object)entry.getMaintainer().getAddress());
        Assert.assertNotNull((Object)entry.getDate());
        Assert.assertEquals((Object)this.parseDate("Wed, 04 May 2016 15:05:00 +0200"), (Object)entry.getDate());
        source = ChangeLogParserImplTest.createSource(Arrays.asList("mypackage (1.1.0) trusty; urgency=low", "", "  * change details", "    more change details", "", "  * even more change details", "", " -- John Doe <j.doe@example.com>  Wed, 04 May 2016 15:05:00 +0200", "", "mypackage (1.0.0) lucid; urgency=HIGH", "  * change details", "", "", "  * even more change details", " -- John Doe <j.doe@example.com>  Fri, 02 Jan 2015 10:37:00 +0100"), "copyright");
        try {
            changeLog = parser.parseChangeLog(source, (Context)context);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertNotNull((Object)changeLog);
        entries = changeLog.getEntries();
        Assert.assertNotNull((Object)entries);
        Assert.assertEquals((long)2L, (long)entries.size());
        entry = (ChangeLogVersionEntry)entries.get(0);
        Assert.assertNotNull((Object)entry);
        Assert.assertNotNull((Object)entry.getPackage());
        Assert.assertEquals((Object)"mypackage", (Object)entry.getPackage().getName());
        Assert.assertNotNull((Object)entry.getVersion());
        Assert.assertEquals((Object)"1.1.0", (Object)entry.getVersion().getText());
        distributions = entry.getDistributions();
        Assert.assertNotNull((Object)distributions);
        Assert.assertEquals((long)1L, (long)distributions.size());
        Assert.assertEquals((Object)"trusty", distributions.get(0));
        Assert.assertNotNull((Object)entry.getUrgency());
        Assert.assertEquals((Object)"low", (Object)entry.getUrgency().getText());
        details = entry.getDetails();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((long)2L, (long)details.size());
        detail = (ChangeLogVersionEntryDetail)details.get(0);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"change details\nmore change details", (Object)detail.getText());
        detail = (ChangeLogVersionEntryDetail)details.get(1);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"even more change details", (Object)detail.getText());
        Assert.assertNotNull((Object)entry.getMaintainer());
        Assert.assertEquals((Object)"John Doe", (Object)entry.getMaintainer().getName());
        Assert.assertEquals((Object)"j.doe@example.com", (Object)entry.getMaintainer().getAddress());
        Assert.assertNotNull((Object)entry.getDate());
        Assert.assertEquals((Object)this.parseDate("Wed, 04 May 2016 15:05:00 +0200"), (Object)entry.getDate());
        entry = (ChangeLogVersionEntry)entries.get(1);
        Assert.assertNotNull((Object)entry);
        Assert.assertNotNull((Object)entry.getPackage());
        Assert.assertEquals((Object)"mypackage", (Object)entry.getPackage().getName());
        Assert.assertNotNull((Object)entry.getVersion());
        Assert.assertEquals((Object)"1.0.0", (Object)entry.getVersion().getText());
        distributions = entry.getDistributions();
        Assert.assertNotNull((Object)distributions);
        Assert.assertEquals((long)1L, (long)distributions.size());
        Assert.assertEquals((Object)"lucid", distributions.get(0));
        Assert.assertNotNull((Object)entry.getUrgency());
        Assert.assertEquals((Object)"high", (Object)entry.getUrgency().getText());
        details = entry.getDetails();
        Assert.assertNotNull((Object)details);
        Assert.assertEquals((long)2L, (long)details.size());
        detail = (ChangeLogVersionEntryDetail)details.get(0);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"change details", (Object)detail.getText());
        detail = (ChangeLogVersionEntryDetail)details.get(1);
        Assert.assertNotNull((Object)detail);
        Assert.assertEquals((Object)"even more change details", (Object)detail.getText());
        Assert.assertNotNull((Object)entry.getMaintainer());
        Assert.assertEquals((Object)"John Doe", (Object)entry.getMaintainer().getName());
        Assert.assertEquals((Object)"j.doe@example.com", (Object)entry.getMaintainer().getAddress());
        Assert.assertNotNull((Object)entry.getDate());
        Assert.assertEquals((Object)this.parseDate("Fri, 02 Jan 2015 10:37:00 +0100"), (Object)entry.getDate());
    }

    private Date parseDate(String value) {
        Date date;
        try {
            date = TIMESTAMP_FORMAT.parse(value);
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare timestamp |" + value + "|: " + e.getMessage()));
            return null;
        }
        return date;
    }
}

