/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.ChangeLog;
import net.sourceforge.javadpkg.ChangeLogVersionEntry;
import net.sourceforge.javadpkg.ChangeLogVersionEntryDetail;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.impl.ChangeLogBuilderImpl;
import net.sourceforge.javadpkg.impl.ChangeLogImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryDetailImpl;
import net.sourceforge.javadpkg.impl.ChangeLogVersionEntryImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import org.junit.Assert;
import org.junit.Test;

public class ChangeLogBuilderImplTest
extends AbstractDpkgTest {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);

    @Test
    public void test() {
        ChangeLogBuilderImpl builder = new ChangeLogBuilderImpl();
        ChangeLogImpl changeLog = new ChangeLogImpl();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataStreamTarget target = new DataStreamTarget((OutputStream)out, "changelog", false);
        ContextImpl context = new ContextImpl();
        try {
            builder.buildChangeLog(null, (DataTarget)target, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildChangeLog((ChangeLog)changeLog, null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildChangeLog((ChangeLog)changeLog, (DataTarget)target, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        changeLog = new ChangeLogImpl();
        ChangeLogVersionEntryImpl entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(ChangeLogBuilderImplTest.createPackageName("mypackage"));
        entry.setVersion(ChangeLogBuilderImplTest.createPackageVersion("1.0.0"));
        entry.setDistributions(Arrays.asList("lucid", "precise", "trusty"));
        entry.setUrgency(ChangeLogBuilderImplTest.createChangeLogUrgency("low"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("change details\nmore change details\n\nmore change details after an empty line"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("even more change details"));
        entry.setMaintainer(ChangeLogBuilderImplTest.createPackageMaintainer("John Doe <j.doe@example.com>"));
        entry.setDate(this.parseDate("Wed, 04 May 2016 15:05:00 +0200"));
        changeLog.addEntry((ChangeLogVersionEntry)entry);
        out = new ByteArrayOutputStream();
        target = new DataStreamTarget((OutputStream)out, "changelog", false);
        try {
            builder.buildChangeLog((ChangeLog)changeLog, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"mypackage (1.0.0) lucid precise trusty; urgency=low\n\n  * change details\n    more change details\n    .\n    more change details after an empty line\n\n  * even more change details\n\n -- John Doe <j.doe@example.com>  Wed, 04 May 2016 15:05:00 +0200\n", (Object)new String(out.toByteArray()));
        changeLog = new ChangeLogImpl();
        entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(ChangeLogBuilderImplTest.createPackageName("mypackage"));
        entry.setVersion(ChangeLogBuilderImplTest.createPackageVersion("1.1.0"));
        entry.setDistributions(Arrays.asList("trusty"));
        entry.setUrgency(ChangeLogBuilderImplTest.createChangeLogUrgency("low"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("change details\nmore change details"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("even more change details"));
        entry.setMaintainer(ChangeLogBuilderImplTest.createPackageMaintainer("John Doe <j.doe@example.com>"));
        entry.setDate(this.parseDate("Wed, 04 May 2016 15:05:00 +0200"));
        changeLog.addEntry((ChangeLogVersionEntry)entry);
        entry = new ChangeLogVersionEntryImpl();
        entry.setPackageName(ChangeLogBuilderImplTest.createPackageName("mypackage"));
        entry.setVersion(ChangeLogBuilderImplTest.createPackageVersion("1.0.0"));
        entry.setDistributions(Arrays.asList("lucid"));
        entry.setUrgency(ChangeLogBuilderImplTest.createChangeLogUrgency("high"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("change details"));
        entry.addDetail((ChangeLogVersionEntryDetail)new ChangeLogVersionEntryDetailImpl("even more change details"));
        entry.setMaintainer(ChangeLogBuilderImplTest.createPackageMaintainer("John Doe <j.doe@example.com>"));
        entry.setDate(this.parseDate("Fri, 02 Jan 2015 10:37:00 +0100"));
        changeLog.addEntry((ChangeLogVersionEntry)entry);
        out = new ByteArrayOutputStream();
        target = new DataStreamTarget((OutputStream)out, "changelog", false);
        try {
            builder.buildChangeLog((ChangeLog)changeLog, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"mypackage (1.1.0) trusty; urgency=low\n\n  * change details\n    more change details\n\n  * even more change details\n\n -- John Doe <j.doe@example.com>  Wed, 04 May 2016 15:05:00 +0200\n\nmypackage (1.0.0) lucid; urgency=high\n\n  * change details\n\n  * even more change details\n\n -- John Doe <j.doe@example.com>  Fri, 02 Jan 2015 10:37:00 +0100\n", (Object)new String(out.toByteArray()));
    }

    private Date parseDate(String value) {
        Date date;
        try {
            date = TIMESTAMP_FORMAT.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't prepare timestamp |" + value + "|: " + e.getMessage()));
            return null;
        }
        return date;
    }
}

