/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.field.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.BuildException;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.field.impl.FieldBuilderImpl;
import net.sourceforge.javadpkg.field.impl.FieldImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataStreamTarget;
import org.junit.Assert;
import org.junit.Test;

public class FieldBuilderImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        FieldBuilderImpl builder = new FieldBuilderImpl();
        ArrayList<FieldImpl> fields = new ArrayList<FieldImpl>();
        fields.add(new FieldImpl("Package", "mypackage"));
        fields.add(new FieldImpl("Version", "1.0.0"));
        fields.add(new FieldImpl("Section", "net"));
        fields.add(new FieldImpl("Priority", "optional"));
        fields.add(new FieldImpl("Architecture", "amd64"));
        fields.add(new FieldImpl("Depends", "oracle-8-jre (>= 1.8.0)"));
        fields.add(new FieldImpl("Installed-Size", "12345"));
        fields.add(new FieldImpl("Homepage", "http://www.example.com/"));
        fields.add(new FieldImpl("Maintainer", "John Doe <j.doe@example.com>"));
        fields.add(new FieldImpl("Description", "This is my first package.\nI'm somewhat excited.\n.\nThis will be a great package.\n."));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataStreamTarget target = new DataStreamTarget((OutputStream)out, "control", false);
        ContextImpl context = new ContextImpl();
        try {
            builder.buildFields(null, (DataTarget)target, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildFields(fields, null, (Context)context);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildFields(fields, (DataTarget)target, null);
            Assert.fail((String)"Expected an exception, but none was thrown.");
        }
        catch (IllegalArgumentException e) {
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        try {
            builder.buildFields(fields, (DataTarget)target, (Context)context);
        }
        catch (IOException | BuildException e) {
            e.printStackTrace();
            Assert.fail((String)("An unexpected exception was thrown: " + e.getMessage()));
            return;
        }
        List warnings = context.getWarnings();
        Assert.assertNotNull((Object)warnings);
        Assert.assertEquals((long)0L, (long)warnings.size());
        Assert.assertEquals((Object)"Package: mypackage\nVersion: 1.0.0\nSection: net\nPriority: optional\nArchitecture: amd64\nDepends: oracle-8-jre (>= 1.8.0)\nInstalled-Size: 12345\nHomepage: http://www.example.com/\nMaintainer: John Doe <j.doe@example.com>\nDescription: This is my first package.\n I'm somewhat excited.\n .\n This will be a great package.\n .\n", (Object)new String(out.toByteArray()));
    }
}

