/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.control.impl;

import net.sourceforge.javadpkg.AbstractDpkgTest;
import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.ParseException;
import net.sourceforge.javadpkg.control.PackageVersion;
import net.sourceforge.javadpkg.control.impl.PackageVersionParserImpl;
import net.sourceforge.javadpkg.impl.ContextImpl;
import org.junit.Assert;
import org.junit.Test;

public class PackageVersionParserImplTest
extends AbstractDpkgTest {
    @Test
    public void test() {
        PackageVersion version;
        PackageVersionParserImpl parser = new PackageVersionParserImpl();
        ContextImpl context = new ContextImpl();
        try {
            parser.parsePackageVersion(null, (Context)context);
            Assert.fail((String)"Expected an exception, but the method didn't throw any.");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        try {
            parser.parsePackageVersion("", null);
            Assert.fail((String)"Expected an exception, but the method didn't throw any.");
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        context = new ContextImpl();
        try {
            version = parser.parsePackageVersion("1.2.3", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)"1.2.3", (Object)version.getText());
        Assert.assertNull((Object)version.getEpoch());
        Assert.assertEquals((Object)"1.2.3", (Object)version.getUpstreamVersion());
        Assert.assertNull((Object)version.getDebianRevision());
        context = new ContextImpl();
        try {
            version = parser.parsePackageVersion("1:2.3.4", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)"1:2.3.4", (Object)version.getText());
        Assert.assertEquals((Object)"1", (Object)version.getEpoch());
        Assert.assertEquals((Object)"2.3.4", (Object)version.getUpstreamVersion());
        Assert.assertNull((Object)version.getDebianRevision());
        context = new ContextImpl();
        try {
            version = parser.parsePackageVersion("1.2.3-4", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)"1.2.3-4", (Object)version.getText());
        Assert.assertNull((Object)version.getEpoch());
        Assert.assertEquals((Object)"1.2.3", (Object)version.getUpstreamVersion());
        Assert.assertEquals((Object)"4", (Object)version.getDebianRevision());
        context = new ContextImpl();
        try {
            version = parser.parsePackageVersion("1:2.3.4-5", (Context)context);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Assert.fail((String)("Method threw unexpected exception: " + e.getMessage()));
            return;
        }
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)"1:2.3.4-5", (Object)version.getText());
        Assert.assertEquals((Object)"1", (Object)version.getEpoch());
        Assert.assertEquals((Object)"2.3.4", (Object)version.getUpstreamVersion());
        Assert.assertEquals((Object)"5", (Object)version.getDebianRevision());
    }
}

